/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.Address;

public class AddressUnmarshaller
implements Unmarshaller<Address, JsonUnmarshallerContext> {
    private static final AddressUnmarshaller INSTANCE = new AddressUnmarshaller();

    public Address unmarshall(JsonUnmarshallerContext context) throws Exception {
        Address.Builder addressBuilder = Address.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AddressId", targetDepth)) {
                    context.nextToken();
                    addressBuilder.addressId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    addressBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Company", targetDepth)) {
                    context.nextToken();
                    addressBuilder.company((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Street1", targetDepth)) {
                    context.nextToken();
                    addressBuilder.street1((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Street2", targetDepth)) {
                    context.nextToken();
                    addressBuilder.street2((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Street3", targetDepth)) {
                    context.nextToken();
                    addressBuilder.street3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("City", targetDepth)) {
                    context.nextToken();
                    addressBuilder.city((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StateOrProvince", targetDepth)) {
                    context.nextToken();
                    addressBuilder.stateOrProvince((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrefectureOrDistrict", targetDepth)) {
                    context.nextToken();
                    addressBuilder.prefectureOrDistrict((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Landmark", targetDepth)) {
                    context.nextToken();
                    addressBuilder.landmark((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Country", targetDepth)) {
                    context.nextToken();
                    addressBuilder.country((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PostalCode", targetDepth)) {
                    context.nextToken();
                    addressBuilder.postalCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PhoneNumber", targetDepth)) {
                    context.nextToken();
                    addressBuilder.phoneNumber((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("IsRestricted", targetDepth)) {
                    context.nextToken();
                    addressBuilder.isRestricted((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Address)addressBuilder.build();
    }

    public static AddressUnmarshaller getInstance() {
        return INSTANCE;
    }
}

