/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ShippingOption {
    SECOND_DAY("SECOND_DAY"),
    NEXT_DAY("NEXT_DAY"),
    EXPRESS("EXPRESS"),
    STANDARD("STANDARD");

    private final String value;

    private ShippingOption(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ShippingOption fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ShippingOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

