/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ShipmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Shipment
implements StructuredPojo,
ToCopyableBuilder<Builder, Shipment> {
    private final String status;
    private final String trackingNumber;

    private Shipment(BuilderImpl builder) {
        this.status = builder.status;
        this.trackingNumber = builder.trackingNumber;
    }

    public String status() {
        return this.status;
    }

    public String trackingNumber() {
        return this.trackingNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.trackingNumber() == null ? 0 : this.trackingNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shipment)) {
            return false;
        }
        Shipment other = (Shipment)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.trackingNumber() == null ^ this.trackingNumber() == null) {
            return false;
        }
        return other.trackingNumber() == null || other.trackingNumber().equals(this.trackingNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.trackingNumber() != null) {
            sb.append("TrackingNumber: ").append(this.trackingNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShipmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private String trackingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Shipment model) {
            this.setStatus(model.status);
            this.setTrackingNumber(model.trackingNumber);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTrackingNumber() {
            return this.trackingNumber;
        }

        @Override
        public final Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public final void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        public Shipment build() {
            return new Shipment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Shipment> {
        public Builder status(String var1);

        public Builder trackingNumber(String var1);
    }
}

