/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.services.snowball.transform.JobListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, JobListEntry> {
    private final String jobId;
    private final String jobState;
    private final Boolean isMaster;
    private final String jobType;
    private final String snowballType;
    private final Instant creationDate;
    private final String description;

    private JobListEntry(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.isMaster = builder.isMaster;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobState() {
        return this.jobState;
    }

    public Boolean isMaster() {
        return this.isMaster;
    }

    public String jobType() {
        return this.jobType;
    }

    public String snowballType() {
        return this.snowballType;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.jobState() == null ? 0 : this.jobState().hashCode());
        hashCode = 31 * hashCode + (this.isMaster() == null ? 0 : this.isMaster().hashCode());
        hashCode = 31 * hashCode + (this.jobType() == null ? 0 : this.jobType().hashCode());
        hashCode = 31 * hashCode + (this.snowballType() == null ? 0 : this.snowballType().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListEntry)) {
            return false;
        }
        JobListEntry other = (JobListEntry)obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobState() == null ^ this.jobState() == null) {
            return false;
        }
        if (other.jobState() != null && !other.jobState().equals(this.jobState())) {
            return false;
        }
        if (other.isMaster() == null ^ this.isMaster() == null) {
            return false;
        }
        if (other.isMaster() != null && !other.isMaster().equals(this.isMaster())) {
            return false;
        }
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.jobState() != null) {
            sb.append("JobState: ").append(this.jobState()).append(",");
        }
        if (this.isMaster() != null) {
            sb.append("IsMaster: ").append(this.isMaster()).append(",");
        }
        if (this.jobType() != null) {
            sb.append("JobType: ").append(this.jobType()).append(",");
        }
        if (this.snowballType() != null) {
            sb.append("SnowballType: ").append(this.snowballType()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobState;
        private Boolean isMaster;
        private String jobType;
        private String snowballType;
        private Instant creationDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListEntry model) {
            this.setJobId(model.jobId);
            this.setJobState(model.jobState);
            this.setIsMaster(model.isMaster);
            this.setJobType(model.jobType);
            this.setSnowballType(model.snowballType);
            this.setCreationDate(model.creationDate);
            this.setDescription(model.description);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return this.jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final Boolean getIsMaster() {
            return this.isMaster;
        }

        @Override
        public final Builder isMaster(Boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public final void setIsMaster(Boolean isMaster) {
            this.isMaster = isMaster;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public JobListEntry build() {
            return new JobListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobListEntry> {
        public Builder jobId(String var1);

        public Builder jobState(String var1);

        public Builder jobState(JobState var1);

        public Builder isMaster(Boolean var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);
    }
}

