/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballCapacityPreference").isBinary(false).build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();
    private static final UpdateJobRequestModelMarshaller INSTANCE = new UpdateJobRequestModelMarshaller();

    private UpdateJobRequestModelMarshaller() {
    }

    public static UpdateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateJobRequest updateJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateJobRequest), (String)"updateJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateJobRequest.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.shippingOptionAsString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.snowballCapacityPreferenceAsString(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)updateJobRequest.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

