/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.JobLogsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobLogs
implements StructuredPojo,
ToCopyableBuilder<Builder, JobLogs> {
    private final String jobCompletionReportURI;
    private final String jobSuccessLogURI;
    private final String jobFailureLogURI;

    private JobLogs(BuilderImpl builder) {
        this.jobCompletionReportURI = builder.jobCompletionReportURI;
        this.jobSuccessLogURI = builder.jobSuccessLogURI;
        this.jobFailureLogURI = builder.jobFailureLogURI;
    }

    public String jobCompletionReportURI() {
        return this.jobCompletionReportURI;
    }

    public String jobSuccessLogURI() {
        return this.jobSuccessLogURI;
    }

    public String jobFailureLogURI() {
        return this.jobFailureLogURI;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCompletionReportURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSuccessLogURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFailureLogURI());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLogs)) {
            return false;
        }
        JobLogs other = (JobLogs)obj;
        return Objects.equals(this.jobCompletionReportURI(), other.jobCompletionReportURI()) && Objects.equals(this.jobSuccessLogURI(), other.jobSuccessLogURI()) && Objects.equals(this.jobFailureLogURI(), other.jobFailureLogURI());
    }

    public String toString() {
        return ToString.builder((String)"JobLogs").add("JobCompletionReportURI", (Object)this.jobCompletionReportURI()).add("JobSuccessLogURI", (Object)this.jobSuccessLogURI()).add("JobFailureLogURI", (Object)this.jobFailureLogURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobCompletionReportURI": {
                return Optional.of(clazz.cast(this.jobCompletionReportURI()));
            }
            case "JobSuccessLogURI": {
                return Optional.of(clazz.cast(this.jobSuccessLogURI()));
            }
            case "JobFailureLogURI": {
                return Optional.of(clazz.cast(this.jobFailureLogURI()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobLogsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobCompletionReportURI;
        private String jobSuccessLogURI;
        private String jobFailureLogURI;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLogs model) {
            this.jobCompletionReportURI(model.jobCompletionReportURI);
            this.jobSuccessLogURI(model.jobSuccessLogURI);
            this.jobFailureLogURI(model.jobFailureLogURI);
        }

        public final String getJobCompletionReportURI() {
            return this.jobCompletionReportURI;
        }

        @Override
        public final Builder jobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
            return this;
        }

        public final void setJobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
        }

        public final String getJobSuccessLogURI() {
            return this.jobSuccessLogURI;
        }

        @Override
        public final Builder jobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
            return this;
        }

        public final void setJobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
        }

        public final String getJobFailureLogURI() {
            return this.jobFailureLogURI;
        }

        @Override
        public final Builder jobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
            return this;
        }

        public final void setJobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
        }

        public JobLogs build() {
            return new JobLogs(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobLogs> {
        public Builder jobCompletionReportURI(String var1);

        public Builder jobSuccessLogURI(String var1);

        public Builder jobFailureLogURI(String var1);
    }
}

