/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.services.snowball.model.JobMetadataListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private final JobMetadata jobMetadata;
    private final List<JobMetadata> subJobMetadata;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobMetadata = builder.jobMetadata;
        this.subJobMetadata = builder.subJobMetadata;
    }

    public JobMetadata jobMetadata() {
        return this.jobMetadata;
    }

    public List<JobMetadata> subJobMetadata() {
        return this.subJobMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.subJobMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.jobMetadata(), other.jobMetadata()) && Objects.equals(this.subJobMetadata(), other.subJobMetadata());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobResponse").add("JobMetadata", (Object)this.jobMetadata()).add("SubJobMetadata", this.subJobMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobMetadata": {
                return Optional.of(clazz.cast(this.jobMetadata()));
            }
            case "SubJobMetadata": {
                return Optional.of(clazz.cast(this.subJobMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private JobMetadata jobMetadata;
        private List<JobMetadata> subJobMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            this.jobMetadata(model.jobMetadata);
            this.subJobMetadata(model.subJobMetadata);
        }

        public final JobMetadata.Builder getJobMetadata() {
            return this.jobMetadata != null ? this.jobMetadata.toBuilder() : null;
        }

        @Override
        public final Builder jobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(JobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        public final Collection<JobMetadata.Builder> getSubJobMetadata() {
            return this.subJobMetadata != null ? (Collection)this.subJobMetadata.stream().map(JobMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(JobMetadata ... subJobMetadata) {
            this.subJobMetadata(Arrays.asList(subJobMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(Consumer<JobMetadata.Builder> ... subJobMetadata) {
            this.subJobMetadata(Stream.of(subJobMetadata).map(c -> (JobMetadata)((JobMetadata.Builder)JobMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubJobMetadata(Collection<JobMetadata.BuilderImpl> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copyFromBuilder(subJobMetadata);
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder jobMetadata(JobMetadata var1);

        default public Builder jobMetadata(Consumer<JobMetadata.Builder> jobMetadata) {
            return this.jobMetadata((JobMetadata)((JobMetadata.Builder)JobMetadata.builder().apply(jobMetadata)).build());
        }

        public Builder subJobMetadata(Collection<JobMetadata> var1);

        public Builder subJobMetadata(JobMetadata ... var1);

        public Builder subJobMetadata(Consumer<JobMetadata.Builder> ... var1);
    }
}

