/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails;
import software.amazon.awssdk.services.sms.model.ReplicationRunState;
import software.amazon.awssdk.services.sms.model.ReplicationRunType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationRun> {
    private static final SdkField<String> REPLICATION_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::replicationRunId)).setter(ReplicationRun.setter(Builder::replicationRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::stateAsString)).setter(ReplicationRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::typeAsString)).setter(ReplicationRun.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<ReplicationRunStageDetails> STAGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicationRun.getter(ReplicationRun::stageDetails)).setter(ReplicationRun.setter(Builder::stageDetails)).constructor(ReplicationRunStageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageDetails").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::statusMessage)).setter(ReplicationRun.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::amiId)).setter(ReplicationRun.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()}).build();
    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReplicationRun.getter(ReplicationRun::scheduledStartTime)).setter(ReplicationRun.setter(Builder::scheduledStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledStartTime").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReplicationRun.getter(ReplicationRun::completedTime)).setter(ReplicationRun.setter(Builder::completedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::description)).setter(ReplicationRun.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ReplicationRun.getter(ReplicationRun::encrypted)).setter(ReplicationRun.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationRun.getter(ReplicationRun::kmsKeyId)).setter(ReplicationRun.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_RUN_ID_FIELD, STATE_FIELD, TYPE_FIELD, STAGE_DETAILS_FIELD, STATUS_MESSAGE_FIELD, AMI_ID_FIELD, SCHEDULED_START_TIME_FIELD, COMPLETED_TIME_FIELD, DESCRIPTION_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationRunId;
    private final String state;
    private final String type;
    private final ReplicationRunStageDetails stageDetails;
    private final String statusMessage;
    private final String amiId;
    private final Instant scheduledStartTime;
    private final Instant completedTime;
    private final String description;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private ReplicationRun(BuilderImpl builder) {
        this.replicationRunId = builder.replicationRunId;
        this.state = builder.state;
        this.type = builder.type;
        this.stageDetails = builder.stageDetails;
        this.statusMessage = builder.statusMessage;
        this.amiId = builder.amiId;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.completedTime = builder.completedTime;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String replicationRunId() {
        return this.replicationRunId;
    }

    public ReplicationRunState state() {
        return ReplicationRunState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ReplicationRunType type() {
        return ReplicationRunType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public ReplicationRunStageDetails stageDetails() {
        return this.stageDetails;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String amiId() {
        return this.amiId;
    }

    public Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    public Instant completedTime() {
        return this.completedTime;
    }

    public String description() {
        return this.description;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRun)) {
            return false;
        }
        ReplicationRun other = (ReplicationRun)obj;
        return Objects.equals(this.replicationRunId(), other.replicationRunId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stageDetails(), other.stageDetails()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.scheduledStartTime(), other.scheduledStartTime()) && Objects.equals(this.completedTime(), other.completedTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationRun").add("ReplicationRunId", (Object)this.replicationRunId()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).add("StageDetails", (Object)this.stageDetails()).add("StatusMessage", (Object)this.statusMessage()).add("AmiId", (Object)this.amiId()).add("ScheduledStartTime", (Object)this.scheduledStartTime()).add("CompletedTime", (Object)this.completedTime()).add("Description", (Object)this.description()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationRunId": {
                return Optional.ofNullable(clazz.cast(this.replicationRunId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "stageDetails": {
                return Optional.ofNullable(clazz.cast(this.stageDetails()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "amiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "scheduledStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledStartTime()));
            }
            case "completedTime": {
                return Optional.ofNullable(clazz.cast(this.completedTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRun, T> g) {
        return obj -> g.apply((ReplicationRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationRunId;
        private String state;
        private String type;
        private ReplicationRunStageDetails stageDetails;
        private String statusMessage;
        private String amiId;
        private Instant scheduledStartTime;
        private Instant completedTime;
        private String description;
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRun model) {
            this.replicationRunId(model.replicationRunId);
            this.state(model.state);
            this.type(model.type);
            this.stageDetails(model.stageDetails);
            this.statusMessage(model.statusMessage);
            this.amiId(model.amiId);
            this.scheduledStartTime(model.scheduledStartTime);
            this.completedTime(model.completedTime);
            this.description(model.description);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationRunId() {
            return this.replicationRunId;
        }

        @Override
        public final Builder replicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
            return this;
        }

        public final void setReplicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplicationRunState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReplicationRunType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ReplicationRunStageDetails.Builder getStageDetails() {
            return this.stageDetails != null ? this.stageDetails.toBuilder() : null;
        }

        @Override
        public final Builder stageDetails(ReplicationRunStageDetails stageDetails) {
            this.stageDetails = stageDetails;
            return this;
        }

        public final void setStageDetails(ReplicationRunStageDetails.BuilderImpl stageDetails) {
            this.stageDetails = stageDetails != null ? stageDetails.build() : null;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final Instant getScheduledStartTime() {
            return this.scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        public final Instant getCompletedTime() {
            return this.completedTime;
        }

        @Override
        public final Builder completedTime(Instant completedTime) {
            this.completedTime = completedTime;
            return this;
        }

        public final void setCompletedTime(Instant completedTime) {
            this.completedTime = completedTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public ReplicationRun build() {
            return new ReplicationRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationRun> {
        public Builder replicationRunId(String var1);

        public Builder state(String var1);

        public Builder state(ReplicationRunState var1);

        public Builder type(String var1);

        public Builder type(ReplicationRunType var1);

        public Builder stageDetails(ReplicationRunStageDetails var1);

        default public Builder stageDetails(Consumer<ReplicationRunStageDetails.Builder> stageDetails) {
            return this.stageDetails((ReplicationRunStageDetails)((ReplicationRunStageDetails.Builder)ReplicationRunStageDetails.builder().applyMutation(stageDetails)).build());
        }

        public Builder statusMessage(String var1);

        public Builder amiId(String var1);

        public Builder scheduledStartTime(Instant var1);

        public Builder completedTime(Instant var1);

        public Builder description(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);
    }
}

