/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration;
import software.amazon.awssdk.services.sms.model.ServerLaunchConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerGroupLaunchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerGroupLaunchConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerGroupLaunchConfiguration.getter(ServerGroupLaunchConfiguration::serverGroupId)).setter(ServerGroupLaunchConfiguration.setter(Builder::serverGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()}).build();
    private static final SdkField<Integer> LAUNCH_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ServerGroupLaunchConfiguration.getter(ServerGroupLaunchConfiguration::launchOrder)).setter(ServerGroupLaunchConfiguration.setter(Builder::launchOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchOrder").build()}).build();
    private static final SdkField<List<ServerLaunchConfiguration>> SERVER_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServerGroupLaunchConfiguration.getter(ServerGroupLaunchConfiguration::serverLaunchConfigurations)).setter(ServerGroupLaunchConfiguration.setter(Builder::serverLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverLaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerLaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD, LAUNCH_ORDER_FIELD, SERVER_LAUNCH_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverGroupId;
    private final Integer launchOrder;
    private final List<ServerLaunchConfiguration> serverLaunchConfigurations;

    private ServerGroupLaunchConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.launchOrder = builder.launchOrder;
        this.serverLaunchConfigurations = builder.serverLaunchConfigurations;
    }

    public String serverGroupId() {
        return this.serverGroupId;
    }

    public Integer launchOrder() {
        return this.launchOrder;
    }

    public List<ServerLaunchConfiguration> serverLaunchConfigurations() {
        return this.serverLaunchConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupLaunchConfiguration)) {
            return false;
        }
        ServerGroupLaunchConfiguration other = (ServerGroupLaunchConfiguration)obj;
        return Objects.equals(this.serverGroupId(), other.serverGroupId()) && Objects.equals(this.launchOrder(), other.launchOrder()) && Objects.equals(this.serverLaunchConfigurations(), other.serverLaunchConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"ServerGroupLaunchConfiguration").add("ServerGroupId", (Object)this.serverGroupId()).add("LaunchOrder", (Object)this.launchOrder()).add("ServerLaunchConfigurations", this.serverLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupId": {
                return Optional.ofNullable(clazz.cast(this.serverGroupId()));
            }
            case "launchOrder": {
                return Optional.ofNullable(clazz.cast(this.launchOrder()));
            }
            case "serverLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupLaunchConfiguration, T> g) {
        return obj -> g.apply((ServerGroupLaunchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverGroupId;
        private Integer launchOrder;
        private List<ServerLaunchConfiguration> serverLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupLaunchConfiguration model) {
            this.serverGroupId(model.serverGroupId);
            this.launchOrder(model.launchOrder);
            this.serverLaunchConfigurations(model.serverLaunchConfigurations);
        }

        public final String getServerGroupId() {
            return this.serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final Integer getLaunchOrder() {
            return this.launchOrder;
        }

        @Override
        public final Builder launchOrder(Integer launchOrder) {
            this.launchOrder = launchOrder;
            return this;
        }

        public final void setLaunchOrder(Integer launchOrder) {
            this.launchOrder = launchOrder;
        }

        public final Collection<ServerLaunchConfiguration.Builder> getServerLaunchConfigurations() {
            return this.serverLaunchConfigurations != null ? (Collection)this.serverLaunchConfigurations.stream().map(ServerLaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverLaunchConfigurations(Collection<ServerLaunchConfiguration> serverLaunchConfigurations) {
            this.serverLaunchConfigurations = ServerLaunchConfigurationsCopier.copy(serverLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverLaunchConfigurations(ServerLaunchConfiguration ... serverLaunchConfigurations) {
            this.serverLaunchConfigurations(Arrays.asList(serverLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverLaunchConfigurations(Consumer<ServerLaunchConfiguration.Builder> ... serverLaunchConfigurations) {
            this.serverLaunchConfigurations(Stream.of(serverLaunchConfigurations).map(c -> (ServerLaunchConfiguration)((ServerLaunchConfiguration.Builder)ServerLaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerLaunchConfigurations(Collection<ServerLaunchConfiguration.BuilderImpl> serverLaunchConfigurations) {
            this.serverLaunchConfigurations = ServerLaunchConfigurationsCopier.copyFromBuilder(serverLaunchConfigurations);
        }

        public ServerGroupLaunchConfiguration build() {
            return new ServerGroupLaunchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerGroupLaunchConfiguration> {
        public Builder serverGroupId(String var1);

        public Builder launchOrder(Integer var1);

        public Builder serverLaunchConfigurations(Collection<ServerLaunchConfiguration> var1);

        public Builder serverLaunchConfigurations(ServerLaunchConfiguration ... var1);

        public Builder serverLaunchConfigurations(Consumer<ServerLaunchConfiguration.Builder> ... var1);
    }
}

