/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.ReplicationJob;

public class GetReplicationJobsIterable
implements SdkIterable<GetReplicationJobsResponse> {
    private final SmsClient client;
    private final GetReplicationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReplicationJobsIterable(SmsClient client, GetReplicationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetReplicationJobsResponseFetcher();
    }

    public Iterator<GetReplicationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplicationJob> replicationJobList() {
        Function<GetReplicationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationJobList() != null) {
                return response.replicationJobList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetReplicationJobsIterable resume(GetReplicationJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetReplicationJobsIterable(this.client, (GetReplicationJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetReplicationJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetReplicationJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetReplicationJobsResponseFetcher
    implements SyncPageFetcher<GetReplicationJobsResponse> {
        private GetReplicationJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetReplicationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetReplicationJobsResponse nextPage(GetReplicationJobsResponse previousPage) {
            if (previousPage == null) {
                return GetReplicationJobsIterable.this.client.getReplicationJobs(GetReplicationJobsIterable.this.firstRequest);
            }
            return GetReplicationJobsIterable.this.client.getReplicationJobs((GetReplicationJobsRequest)((Object)GetReplicationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

