/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.ScriptType;
import software.amazon.awssdk.services.sms.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSMValidationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SSMValidationParameters> {
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(SSMValidationParameters.getter(SSMValidationParameters::source)).setter(SSMValidationParameters.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(SSMValidationParameters.getter(SSMValidationParameters::instanceId)).setter(SSMValidationParameters.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> SCRIPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptType").getter(SSMValidationParameters.getter(SSMValidationParameters::scriptTypeAsString)).setter(SSMValidationParameters.setter(Builder::scriptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptType").build()}).build();
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(SSMValidationParameters.getter(SSMValidationParameters::command)).setter(SSMValidationParameters.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("executionTimeoutSeconds").getter(SSMValidationParameters.getter(SSMValidationParameters::executionTimeoutSeconds)).setter(SSMValidationParameters.setter(Builder::executionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3BucketName").getter(SSMValidationParameters.getter(SSMValidationParameters::outputS3BucketName)).setter(SSMValidationParameters.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3BucketName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, INSTANCE_ID_FIELD, SCRIPT_TYPE_FIELD, COMMAND_FIELD, EXECUTION_TIMEOUT_SECONDS_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SSMValidationParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Source source;
    private final String instanceId;
    private final String scriptType;
    private final String command;
    private final Integer executionTimeoutSeconds;
    private final String outputS3BucketName;

    private SSMValidationParameters(BuilderImpl builder) {
        this.source = builder.source;
        this.instanceId = builder.instanceId;
        this.scriptType = builder.scriptType;
        this.command = builder.command;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.outputS3BucketName = builder.outputS3BucketName;
    }

    public final Source source() {
        return this.source;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ScriptType scriptType() {
        return ScriptType.fromValue(this.scriptType);
    }

    public final String scriptTypeAsString() {
        return this.scriptType;
    }

    public final String command() {
        return this.command;
    }

    public final Integer executionTimeoutSeconds() {
        return this.executionTimeoutSeconds;
    }

    public final String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSMValidationParameters)) {
            return false;
        }
        SSMValidationParameters other = (SSMValidationParameters)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.scriptTypeAsString(), other.scriptTypeAsString()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.executionTimeoutSeconds(), other.executionTimeoutSeconds()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName());
    }

    public final String toString() {
        return ToString.builder((String)"SSMValidationParameters").add("Source", (Object)this.source()).add("InstanceId", (Object)this.instanceId()).add("ScriptType", (Object)this.scriptTypeAsString()).add("Command", (Object)this.command()).add("ExecutionTimeoutSeconds", (Object)this.executionTimeoutSeconds()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "scriptType": {
                return Optional.ofNullable(clazz.cast(this.scriptTypeAsString()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "executionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutSeconds()));
            }
            case "outputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", SOURCE_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("scriptType", SCRIPT_TYPE_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("outputS3BucketName", OUTPUT_S3_BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SSMValidationParameters, T> g) {
        return obj -> g.apply((SSMValidationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Source source;
        private String instanceId;
        private String scriptType;
        private String command;
        private Integer executionTimeoutSeconds;
        private String outputS3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(SSMValidationParameters model) {
            this.source(model.source);
            this.instanceId(model.instanceId);
            this.scriptType(model.scriptType);
            this.command(model.command);
            this.executionTimeoutSeconds(model.executionTimeoutSeconds);
            this.outputS3BucketName(model.outputS3BucketName);
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getScriptType() {
            return this.scriptType;
        }

        public final void setScriptType(String scriptType) {
            this.scriptType = scriptType;
        }

        @Override
        public final Builder scriptType(String scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        @Override
        public final Builder scriptType(ScriptType scriptType) {
            this.scriptType(scriptType == null ? null : scriptType.toString());
            return this;
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Integer getExecutionTimeoutSeconds() {
            return this.executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public SSMValidationParameters build() {
            return new SSMValidationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SSMValidationParameters> {
        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder instanceId(String var1);

        public Builder scriptType(String var1);

        public Builder scriptType(ScriptType var1);

        public Builder command(String var1);

        public Builder executionTimeoutSeconds(Integer var1);

        public Builder outputS3BucketName(String var1);
    }
}

