/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.internal.UserAgentUtils;
import software.amazon.awssdk.services.sms.model.Connector;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;

public class GetConnectorsPublisher
implements SdkPublisher<GetConnectorsResponse> {
    private final SmsAsyncClient client;
    private final GetConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConnectorsPublisher(SmsAsyncClient client, GetConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConnectorsPublisher(SmsAsyncClient client, GetConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Connector> connectorList() {
        Function<GetConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorList() != null) {
                return response.connectorList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetConnectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetConnectorsResponseFetcher
    implements AsyncPageFetcher<GetConnectorsResponse> {
        private GetConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConnectorsResponse> nextPage(GetConnectorsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectorsPublisher.this.client.getConnectors(GetConnectorsPublisher.this.firstRequest);
            }
            return GetConnectorsPublisher.this.client.getConnectors((GetConnectorsRequest)((Object)GetConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

