/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScriptType {
    SHELL_SCRIPT("SHELL_SCRIPT"),
    POWERSHELL_SCRIPT("POWERSHELL_SCRIPT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScriptType> VALUE_MAP;
    private final String value;

    private ScriptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScriptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScriptType> knownValues() {
        EnumSet<ScriptType> knownValues = EnumSet.allOf(ScriptType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScriptType.class, ScriptType::toString);
    }
}

