/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerCatalogStatus {
    NOT_IMPORTED("NOT_IMPORTED"),
    IMPORTING("IMPORTING"),
    AVAILABLE("AVAILABLE"),
    DELETED("DELETED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerCatalogStatus> VALUE_MAP;
    private final String value;

    private ServerCatalogStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerCatalogStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerCatalogStatus> knownValues() {
        EnumSet<ServerCatalogStatus> knownValues = EnumSet.allOf(ServerCatalogStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerCatalogStatus.class, ServerCatalogStatus::toString);
    }
}

