/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.ReplicationJob;

public class GetReplicationJobsPublisher
implements SdkPublisher<GetReplicationJobsResponse> {
    private final SmsAsyncClient client;
    private final GetReplicationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReplicationJobsPublisher(SmsAsyncClient client, GetReplicationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReplicationJobsPublisher(SmsAsyncClient client, GetReplicationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReplicationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReplicationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplicationJob> replicationJobList() {
        Function<GetReplicationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationJobList() != null) {
                return response.replicationJobList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetReplicationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetReplicationJobsPublisher resume(GetReplicationJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetReplicationJobsPublisher(this.client, (GetReplicationJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetReplicationJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetReplicationJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetReplicationJobsResponseFetcher
    implements AsyncPageFetcher<GetReplicationJobsResponse> {
        private GetReplicationJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetReplicationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetReplicationJobsResponse> nextPage(GetReplicationJobsResponse previousPage) {
            if (previousPage == null) {
                return GetReplicationJobsPublisher.this.client.getReplicationJobs(GetReplicationJobsPublisher.this.firstRequest);
            }
            return GetReplicationJobsPublisher.this.client.getReplicationJobs((GetReplicationJobsRequest)((Object)GetReplicationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

