/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.model.CreateAppRequest;
import software.amazon.awssdk.services.sms.model.CreateAppResponse;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorResponse;
import software.amazon.awssdk.services.sms.model.DryRunOperationException;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse;
import software.amazon.awssdk.services.sms.model.GenerateTemplateRequest;
import software.amazon.awssdk.services.sms.model.GenerateTemplateResponse;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppRequest;
import software.amazon.awssdk.services.sms.model.GetAppResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogResponse;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.InternalErrorException;
import software.amazon.awssdk.services.sms.model.InvalidParameterException;
import software.amazon.awssdk.services.sms.model.LaunchAppRequest;
import software.amazon.awssdk.services.sms.model.LaunchAppResponse;
import software.amazon.awssdk.services.sms.model.ListAppsRequest;
import software.amazon.awssdk.services.sms.model.ListAppsResponse;
import software.amazon.awssdk.services.sms.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sms.model.NoConnectorsAvailableException;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.OperationNotPermittedException;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.ReplicationJobAlreadyExistsException;
import software.amazon.awssdk.services.sms.model.ReplicationJobNotFoundException;
import software.amazon.awssdk.services.sms.model.ReplicationRunLimitExceededException;
import software.amazon.awssdk.services.sms.model.ServerCannotBeReplicatedException;
import software.amazon.awssdk.services.sms.model.SmsException;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.services.sms.model.StartAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse;
import software.amazon.awssdk.services.sms.model.StopAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StopAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.TemporarilyUnavailableException;
import software.amazon.awssdk.services.sms.model.TerminateAppRequest;
import software.amazon.awssdk.services.sms.model.TerminateAppResponse;
import software.amazon.awssdk.services.sms.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.sms.model.UpdateAppRequest;
import software.amazon.awssdk.services.sms.model.UpdateAppResponse;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobResponse;
import software.amazon.awssdk.services.sms.paginators.GetConnectorsIterable;
import software.amazon.awssdk.services.sms.paginators.GetReplicationJobsIterable;
import software.amazon.awssdk.services.sms.paginators.GetReplicationRunsIterable;
import software.amazon.awssdk.services.sms.paginators.GetServersIterable;
import software.amazon.awssdk.services.sms.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.CreateReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DisassociateConnectorRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateTemplateRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetConnectorsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationJobsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationRunsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetServersRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportAppCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.LaunchAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.NotifyAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandReplicationRunRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StopAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.TerminateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateReplicationJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSmsClient
implements SmsClient {
    private static final Logger log = Logger.loggerFor(DefaultSmsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSmsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "sms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            CreateAppResponse createAppResponse = (CreateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$createApp$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationJobResponse createReplicationJob(CreateReplicationJobRequest createReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ServerCannotBeReplicatedException, ReplicationJobAlreadyExistsException, NoConnectorsAvailableException, InternalErrorException, TemporarilyUnavailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, createReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationJob");
            CreateReplicationJobResponse createReplicationJobResponse = (CreateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$createReplicationJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            DeleteAppResponse deleteAppResponse = (DeleteAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteApp$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppLaunchConfigurationResponse deleteAppLaunchConfiguration(DeleteAppLaunchConfigurationRequest deleteAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppLaunchConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppLaunchConfiguration");
            DeleteAppLaunchConfigurationResponse deleteAppLaunchConfigurationResponse = (DeleteAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppLaunchConfiguration$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppReplicationConfigurationResponse deleteAppReplicationConfiguration(DeleteAppReplicationConfigurationRequest deleteAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppReplicationConfiguration");
            DeleteAppReplicationConfigurationResponse deleteAppReplicationConfigurationResponse = (DeleteAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppReplicationConfiguration$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppValidationConfigurationResponse deleteAppValidationConfiguration(DeleteAppValidationConfigurationRequest deleteAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppValidationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppValidationConfiguration");
            DeleteAppValidationConfigurationResponse deleteAppValidationConfigurationResponse = (DeleteAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppValidationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppValidationConfiguration$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationJobResponse deleteReplicationJob(DeleteReplicationJobRequest deleteReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationJobNotFoundException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationJob");
            DeleteReplicationJobResponse deleteReplicationJobResponse = (DeleteReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteReplicationJob$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServerCatalogResponse deleteServerCatalog(DeleteServerCatalogRequest deleteServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, deleteServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServerCatalog");
            DeleteServerCatalogResponse deleteServerCatalogResponse = (DeleteServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServerCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServerCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteServerCatalog$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateConnectorResponse disassociateConnector(DisassociateConnectorRequest disassociateConnectorRequest) throws MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, disassociateConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConnector");
            DisassociateConnectorResponse disassociateConnectorResponse = (DisassociateConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$disassociateConnector$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateChangeSetResponse generateChangeSet(GenerateChangeSetRequest generateChangeSetRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateChangeSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, generateChangeSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateChangeSet");
            GenerateChangeSetResponse generateChangeSetResponse = (GenerateChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateChangeSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateChangeSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateChangeSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateChangeSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$generateChangeSet$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateTemplateResponse generateTemplate(GenerateTemplateRequest generateTemplateRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, generateTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateTemplate");
            GenerateTemplateResponse generateTemplateResponse = (GenerateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$generateTemplate$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            GetAppResponse getAppResponse = (GetAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getApp$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppLaunchConfigurationResponse getAppLaunchConfiguration(GetAppLaunchConfigurationRequest getAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppLaunchConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppLaunchConfiguration");
            GetAppLaunchConfigurationResponse getAppLaunchConfigurationResponse = (GetAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppLaunchConfiguration$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppReplicationConfigurationResponse getAppReplicationConfiguration(GetAppReplicationConfigurationRequest getAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppReplicationConfiguration");
            GetAppReplicationConfigurationResponse getAppReplicationConfigurationResponse = (GetAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppReplicationConfiguration$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppValidationConfigurationResponse getAppValidationConfiguration(GetAppValidationConfigurationRequest getAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationConfiguration");
            GetAppValidationConfigurationResponse getAppValidationConfigurationResponse = (GetAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppValidationConfiguration$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppValidationOutputResponse getAppValidationOutput(GetAppValidationOutputRequest getAppValidationOutputRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationOutput");
            GetAppValidationOutputResponse getAppValidationOutputResponse = (GetAppValidationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppValidationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppValidationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppValidationOutput$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConnectorsResponse getConnectors(GetConnectorsRequest getConnectorsRequest) throws UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnectors");
            GetConnectorsResponse getConnectorsResponse = (GetConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getConnectors$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetConnectorsIterable getConnectorsPaginator(GetConnectorsRequest getConnectorsRequest) throws UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        return new GetConnectorsIterable(this, this.applyPaginatorUserAgent(getConnectorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReplicationJobsResponse getReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getReplicationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationJobs");
            GetReplicationJobsResponse getReplicationJobsResponse = (GetReplicationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReplicationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReplicationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReplicationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getReplicationJobs$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetReplicationJobsIterable getReplicationJobsPaginator(GetReplicationJobsRequest getReplicationJobsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        return new GetReplicationJobsIterable(this, this.applyPaginatorUserAgent(getReplicationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReplicationRunsResponse getReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getReplicationRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationRuns");
            GetReplicationRunsResponse getReplicationRunsResponse = (GetReplicationRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationRuns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReplicationRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReplicationRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReplicationRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getReplicationRuns$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetReplicationRunsIterable getReplicationRunsPaginator(GetReplicationRunsRequest getReplicationRunsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        return new GetReplicationRunsIterable(this, this.applyPaginatorUserAgent(getReplicationRunsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServersResponse getServers(GetServersRequest getServersRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, getServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServers");
            GetServersResponse getServersResponse = (GetServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getServers$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetServersIterable getServersPaginator(GetServersRequest getServersRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, AwsServiceException, SdkClientException, SmsException {
        return new GetServersIterable(this, this.applyPaginatorUserAgent(getServersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportAppCatalogResponse importAppCatalog(ImportAppCatalogRequest importAppCatalogRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportAppCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, importAppCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportAppCatalog");
            ImportAppCatalogResponse importAppCatalogResponse = (ImportAppCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportAppCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importAppCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportAppCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importAppCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$importAppCatalog$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportServerCatalogResponse importServerCatalog(ImportServerCatalogRequest importServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, NoConnectorsAvailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportServerCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, importServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportServerCatalog");
            ImportServerCatalogResponse importServerCatalogResponse = (ImportServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportServerCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importServerCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importServerCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$importServerCatalog$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LaunchAppResponse launchApp(LaunchAppRequest launchAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LaunchAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, launchAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LaunchApp");
            LaunchAppResponse launchAppResponse = (LaunchAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LaunchApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)launchAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LaunchAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return launchAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$launchApp$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, listAppsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApps");
            ListAppsResponse listAppsResponse = (ListAppsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAppsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$listApps$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyAppValidationOutputResponse notifyAppValidationOutput(NotifyAppValidationOutputRequest notifyAppValidationOutputRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyAppValidationOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, notifyAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyAppValidationOutput");
            NotifyAppValidationOutputResponse notifyAppValidationOutputResponse = (NotifyAppValidationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyAppValidationOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyAppValidationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyAppValidationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$notifyAppValidationOutput$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppLaunchConfigurationResponse putAppLaunchConfiguration(PutAppLaunchConfigurationRequest putAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppLaunchConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, putAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppLaunchConfiguration");
            PutAppLaunchConfigurationResponse putAppLaunchConfigurationResponse = (PutAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppLaunchConfiguration$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppReplicationConfigurationResponse putAppReplicationConfiguration(PutAppReplicationConfigurationRequest putAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, putAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppReplicationConfiguration");
            PutAppReplicationConfigurationResponse putAppReplicationConfigurationResponse = (PutAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppReplicationConfiguration$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppValidationConfigurationResponse putAppValidationConfiguration(PutAppValidationConfigurationRequest putAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppValidationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, putAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppValidationConfiguration");
            PutAppValidationConfigurationResponse putAppValidationConfigurationResponse = (PutAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppValidationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppValidationConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAppReplicationResponse startAppReplication(StartAppReplicationRequest startAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAppReplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, startAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAppReplication");
            StartAppReplicationResponse startAppReplicationResponse = (StartAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAppReplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startAppReplication$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartOnDemandAppReplicationResponse startOnDemandAppReplication(StartOnDemandAppReplicationRequest startOnDemandAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandAppReplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, startOnDemandAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandAppReplication");
            StartOnDemandAppReplicationResponse startOnDemandAppReplicationResponse = (StartOnDemandAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandAppReplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startOnDemandAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartOnDemandAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startOnDemandAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startOnDemandAppReplication$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartOnDemandReplicationRunResponse startOnDemandReplicationRun(StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationRunLimitExceededException, DryRunOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandReplicationRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, startOnDemandReplicationRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandReplicationRun");
            StartOnDemandReplicationRunResponse startOnDemandReplicationRunResponse = (StartOnDemandReplicationRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandReplicationRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startOnDemandReplicationRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartOnDemandReplicationRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startOnDemandReplicationRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startOnDemandReplicationRun$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopAppReplicationResponse stopAppReplication(StopAppReplicationRequest stopAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAppReplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, stopAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAppReplication");
            StopAppReplicationResponse stopAppReplicationResponse = (StopAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAppReplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$stopAppReplication$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateAppResponse terminateApp(TerminateAppRequest terminateAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, terminateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateApp");
            TerminateAppResponse terminateAppResponse = (TerminateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$terminateApp$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, updateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApp");
            UpdateAppResponse updateAppResponse = (UpdateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$updateApp$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReplicationJobResponse updateReplicationJob(UpdateReplicationJobRequest updateReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, OperationNotPermittedException, UnauthorizedOperationException, ServerCannotBeReplicatedException, ReplicationJobNotFoundException, InternalErrorException, TemporarilyUnavailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(this.clientConfiguration, updateReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationJob");
            UpdateReplicationJobResponse updateReplicationJobResponse = (UpdateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$updateReplicationJob$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").exceptionBuilderSupplier(MissingRequiredParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").exceptionBuilderSupplier(OperationNotPermittedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalError").exceptionBuilderSupplier(InternalErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").exceptionBuilderSupplier(UnauthorizedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DryRunOperationException").exceptionBuilderSupplier(DryRunOperationException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SmsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.189").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SmsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateReplicationJob$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApp$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateApp$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAppReplication$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandReplicationRun$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandAppReplication$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAppReplication$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppValidationConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppReplicationConfiguration$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppLaunchConfiguration$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyAppValidationOutput$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApps$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$launchApp$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importServerCatalog$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importAppCatalog$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServers$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationRuns$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationJobs$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnectors$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationOutput$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationConfiguration$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppReplicationConfiguration$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppLaunchConfiguration$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApp$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateTemplate$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateChangeSet$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConnector$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServerCatalog$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationJob$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppValidationConfiguration$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppReplicationConfiguration$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppLaunchConfiguration$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApp$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApp$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

