/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AppReplicationStatus {
    READY_FOR_CONFIGURATION("READY_FOR_CONFIGURATION"),
    CONFIGURATION_IN_PROGRESS("CONFIGURATION_IN_PROGRESS"),
    CONFIGURATION_INVALID("CONFIGURATION_INVALID"),
    READY_FOR_REPLICATION("READY_FOR_REPLICATION"),
    VALIDATION_IN_PROGRESS("VALIDATION_IN_PROGRESS"),
    REPLICATION_PENDING("REPLICATION_PENDING"),
    REPLICATION_IN_PROGRESS("REPLICATION_IN_PROGRESS"),
    REPLICATED("REPLICATED"),
    PARTIALLY_REPLICATED("PARTIALLY_REPLICATED"),
    DELTA_REPLICATION_IN_PROGRESS("DELTA_REPLICATION_IN_PROGRESS"),
    DELTA_REPLICATED("DELTA_REPLICATED"),
    DELTA_REPLICATION_FAILED("DELTA_REPLICATION_FAILED"),
    REPLICATION_FAILED("REPLICATION_FAILED"),
    REPLICATION_STOPPING("REPLICATION_STOPPING"),
    REPLICATION_STOP_FAILED("REPLICATION_STOP_FAILED"),
    REPLICATION_STOPPED("REPLICATION_STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AppReplicationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppReplicationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AppReplicationStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppReplicationStatus> knownValues() {
        return Stream.of(AppReplicationStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

