/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ValidationStatus {
    READY_FOR_VALIDATION("READY_FOR_VALIDATION"),
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ValidationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ValidationStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationStatus> knownValues() {
        return Stream.of(ValidationStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

