/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration;
import software.amazon.awssdk.services.sms.model.ServerReplicationConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerGroupReplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerGroupReplicationConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerGroupReplicationConfiguration.getter(ServerGroupReplicationConfiguration::serverGroupId)).setter(ServerGroupReplicationConfiguration.setter(Builder::serverGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()}).build();
    private static final SdkField<List<ServerReplicationConfiguration>> SERVER_REPLICATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServerGroupReplicationConfiguration.getter(ServerGroupReplicationConfiguration::serverReplicationConfigurations)).setter(ServerGroupReplicationConfiguration.setter(Builder::serverReplicationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverReplicationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD, SERVER_REPLICATION_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverGroupId;
    private final List<ServerReplicationConfiguration> serverReplicationConfigurations;

    private ServerGroupReplicationConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.serverReplicationConfigurations = builder.serverReplicationConfigurations;
    }

    public String serverGroupId() {
        return this.serverGroupId;
    }

    public boolean hasServerReplicationConfigurations() {
        return this.serverReplicationConfigurations != null && !(this.serverReplicationConfigurations instanceof SdkAutoConstructList);
    }

    public List<ServerReplicationConfiguration> serverReplicationConfigurations() {
        return this.serverReplicationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverReplicationConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupReplicationConfiguration)) {
            return false;
        }
        ServerGroupReplicationConfiguration other = (ServerGroupReplicationConfiguration)obj;
        return Objects.equals(this.serverGroupId(), other.serverGroupId()) && Objects.equals(this.serverReplicationConfigurations(), other.serverReplicationConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"ServerGroupReplicationConfiguration").add("ServerGroupId", (Object)this.serverGroupId()).add("ServerReplicationConfigurations", this.serverReplicationConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupId": {
                return Optional.ofNullable(clazz.cast(this.serverGroupId()));
            }
            case "serverReplicationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverReplicationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupReplicationConfiguration, T> g) {
        return obj -> g.apply((ServerGroupReplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverGroupId;
        private List<ServerReplicationConfiguration> serverReplicationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupReplicationConfiguration model) {
            this.serverGroupId(model.serverGroupId);
            this.serverReplicationConfigurations(model.serverReplicationConfigurations);
        }

        public final String getServerGroupId() {
            return this.serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final Collection<ServerReplicationConfiguration.Builder> getServerReplicationConfigurations() {
            return this.serverReplicationConfigurations != null ? (Collection)this.serverReplicationConfigurations.stream().map(ServerReplicationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverReplicationConfigurations(Collection<ServerReplicationConfiguration> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier.copy(serverReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(ServerReplicationConfiguration ... serverReplicationConfigurations) {
            this.serverReplicationConfigurations(Arrays.asList(serverReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(Consumer<ServerReplicationConfiguration.Builder> ... serverReplicationConfigurations) {
            this.serverReplicationConfigurations(Stream.of(serverReplicationConfigurations).map(c -> (ServerReplicationConfiguration)((ServerReplicationConfiguration.Builder)ServerReplicationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerReplicationConfigurations(Collection<ServerReplicationConfiguration.BuilderImpl> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier.copyFromBuilder(serverReplicationConfigurations);
        }

        public ServerGroupReplicationConfiguration build() {
            return new ServerGroupReplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerGroupReplicationConfiguration> {
        public Builder serverGroupId(String var1);

        public Builder serverReplicationConfigurations(Collection<ServerReplicationConfiguration> var1);

        public Builder serverReplicationConfigurations(ServerReplicationConfiguration ... var1);

        public Builder serverReplicationConfigurations(Consumer<ServerReplicationConfiguration.Builder> ... var1);
    }
}

