/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.ReplicationRun;

public class GetReplicationRunsIterable
implements SdkIterable<GetReplicationRunsResponse> {
    private final SmsClient client;
    private final GetReplicationRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReplicationRunsIterable(SmsClient client, GetReplicationRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetReplicationRunsResponseFetcher();
    }

    public Iterator<GetReplicationRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplicationRun> replicationRunList() {
        Function<GetReplicationRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationRunList() != null) {
                return response.replicationRunList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetReplicationRunsIterable resume(GetReplicationRunsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetReplicationRunsIterable(this.client, (GetReplicationRunsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetReplicationRunsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetReplicationRunsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetReplicationRunsResponseFetcher
    implements SyncPageFetcher<GetReplicationRunsResponse> {
        private GetReplicationRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetReplicationRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetReplicationRunsResponse nextPage(GetReplicationRunsResponse previousPage) {
            if (previousPage == null) {
                return GetReplicationRunsIterable.this.client.getReplicationRuns(GetReplicationRunsIterable.this.firstRequest);
            }
            return GetReplicationRunsIterable.this.client.getReplicationRuns((GetReplicationRunsRequest)((Object)GetReplicationRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

