/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServerMarshaller {
    private static final MarshallingInfo<String> SERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverId").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VMSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServer").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REPLICATIONJOBTERMINATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobTerminated").isBinary(false).build();
    private static final ServerMarshaller INSTANCE = new ServerMarshaller();

    private ServerMarshaller() {
    }

    public static ServerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Server server, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)server, (String)"server");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)server.serverId(), SERVERID_BINDING);
            protocolMarshaller.marshall((Object)server.serverTypeAsString(), SERVERTYPE_BINDING);
            protocolMarshaller.marshall((Object)server.vmServer(), VMSERVER_BINDING);
            protocolMarshaller.marshall((Object)server.replicationJobId(), REPLICATIONJOBID_BINDING);
            protocolMarshaller.marshall((Object)server.replicationJobTerminated(), REPLICATIONJOBTERMINATED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

