/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.model.ReplicationJob;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationJobMarshaller {
    private static final MarshallingInfo<String> REPLICATIONJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobId").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverId").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VMSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServer").isBinary(false).build();
    private static final MarshallingInfo<Instant> SEEDREPLICATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seedReplicationTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> FREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").isBinary(false).build();
    private static final MarshallingInfo<Instant> NEXTREPLICATIONRUNSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextReplicationRunStartTime").isBinary(false).build();
    private static final MarshallingInfo<String> LICENSETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseType").isBinary(false).build();
    private static final MarshallingInfo<String> ROLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleName").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestAmiId").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICATIONRUNLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationRunList").isBinary(false).build();
    private static final ReplicationJobMarshaller INSTANCE = new ReplicationJobMarshaller();

    private ReplicationJobMarshaller() {
    }

    public static ReplicationJobMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationJob replicationJob, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationJob, (String)"replicationJob");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationJob.replicationJobId(), REPLICATIONJOBID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.serverId(), SERVERID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.serverTypeAsString(), SERVERTYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.vmServer(), VMSERVER_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.seedReplicationTime(), SEEDREPLICATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.frequency(), FREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.nextReplicationRunStartTime(), NEXTREPLICATIONRUNSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.licenseTypeAsString(), LICENSETYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.roleName(), ROLENAME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.latestAmiId(), LATESTAMIID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(replicationJob.replicationRunList(), REPLICATIONRUNLIST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

