/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportServerCatalogRequestMarshaller
implements Marshaller<Request<ImportServerCatalogRequest>, ImportServerCatalogRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(false).operationIdentifier("AWSServerMigrationService_V2016_10_24.ImportServerCatalog").serviceName("SMS").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ImportServerCatalogRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ImportServerCatalogRequest> marshall(ImportServerCatalogRequest importServerCatalogRequest) {
        Validate.paramNotNull((Object)((Object)importServerCatalogRequest), (String)"importServerCatalogRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)importServerCatalogRequest);
            protocolMarshaller.startMarshalling();
            ImportServerCatalogRequestModelMarshaller.getInstance().marshall(importServerCatalogRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

