/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.model.VmManagerType;
import software.amazon.awssdk.services.sms.model.VmServerAddress;
import software.amazon.awssdk.services.sms.transform.VmServerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VmServer
implements StructuredPojo,
ToCopyableBuilder<Builder, VmServer> {
    private final VmServerAddress vmServerAddress;
    private final String vmName;
    private final String vmManagerName;
    private final String vmManagerType;
    private final String vmPath;

    private VmServer(BuilderImpl builder) {
        this.vmServerAddress = builder.vmServerAddress;
        this.vmName = builder.vmName;
        this.vmManagerName = builder.vmManagerName;
        this.vmManagerType = builder.vmManagerType;
        this.vmPath = builder.vmPath;
    }

    public VmServerAddress vmServerAddress() {
        return this.vmServerAddress;
    }

    public String vmName() {
        return this.vmName;
    }

    public String vmManagerName() {
        return this.vmManagerName;
    }

    public VmManagerType vmManagerType() {
        return VmManagerType.fromValue(this.vmManagerType);
    }

    public String vmManagerTypeAsString() {
        return this.vmManagerType;
    }

    public String vmPath() {
        return this.vmPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vmServerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmServer)) {
            return false;
        }
        VmServer other = (VmServer)obj;
        return Objects.equals(this.vmServerAddress(), other.vmServerAddress()) && Objects.equals(this.vmName(), other.vmName()) && Objects.equals(this.vmManagerName(), other.vmManagerName()) && Objects.equals(this.vmManagerTypeAsString(), other.vmManagerTypeAsString()) && Objects.equals(this.vmPath(), other.vmPath());
    }

    public String toString() {
        return ToString.builder((String)"VmServer").add("VmServerAddress", (Object)this.vmServerAddress()).add("VmName", (Object)this.vmName()).add("VmManagerName", (Object)this.vmManagerName()).add("VmManagerType", (Object)this.vmManagerTypeAsString()).add("VmPath", (Object)this.vmPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vmServerAddress": {
                return Optional.ofNullable(clazz.cast(this.vmServerAddress()));
            }
            case "vmName": {
                return Optional.ofNullable(clazz.cast(this.vmName()));
            }
            case "vmManagerName": {
                return Optional.ofNullable(clazz.cast(this.vmManagerName()));
            }
            case "vmManagerType": {
                return Optional.ofNullable(clazz.cast(this.vmManagerTypeAsString()));
            }
            case "vmPath": {
                return Optional.ofNullable(clazz.cast(this.vmPath()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VmServerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private VmServerAddress vmServerAddress;
        private String vmName;
        private String vmManagerName;
        private String vmManagerType;
        private String vmPath;

        private BuilderImpl() {
        }

        private BuilderImpl(VmServer model) {
            this.vmServerAddress(model.vmServerAddress);
            this.vmName(model.vmName);
            this.vmManagerName(model.vmManagerName);
            this.vmManagerType(model.vmManagerType);
            this.vmPath(model.vmPath);
        }

        public final VmServerAddress.Builder getVmServerAddress() {
            return this.vmServerAddress != null ? this.vmServerAddress.toBuilder() : null;
        }

        @Override
        public final Builder vmServerAddress(VmServerAddress vmServerAddress) {
            this.vmServerAddress = vmServerAddress;
            return this;
        }

        public final void setVmServerAddress(VmServerAddress.BuilderImpl vmServerAddress) {
            this.vmServerAddress = vmServerAddress != null ? vmServerAddress.build() : null;
        }

        public final String getVmName() {
            return this.vmName;
        }

        @Override
        public final Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public final void setVmName(String vmName) {
            this.vmName = vmName;
        }

        public final String getVmManagerName() {
            return this.vmManagerName;
        }

        @Override
        public final Builder vmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
            return this;
        }

        public final void setVmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
        }

        public final String getVmManagerType() {
            return this.vmManagerType;
        }

        @Override
        public final Builder vmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
            return this;
        }

        @Override
        public final Builder vmManagerType(VmManagerType vmManagerType) {
            this.vmManagerType(vmManagerType.toString());
            return this;
        }

        public final void setVmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
        }

        public final String getVmPath() {
            return this.vmPath;
        }

        @Override
        public final Builder vmPath(String vmPath) {
            this.vmPath = vmPath;
            return this;
        }

        public final void setVmPath(String vmPath) {
            this.vmPath = vmPath;
        }

        public VmServer build() {
            return new VmServer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VmServer> {
        public Builder vmServerAddress(VmServerAddress var1);

        default public Builder vmServerAddress(Consumer<VmServerAddress.Builder> vmServerAddress) {
            return this.vmServerAddress((VmServerAddress)((VmServerAddress.Builder)VmServerAddress.builder().applyMutation(vmServerAddress)).build());
        }

        public Builder vmName(String var1);

        public Builder vmManagerName(String var1);

        public Builder vmManagerType(String var1);

        public Builder vmManagerType(VmManagerType var1);

        public Builder vmPath(String var1);
    }
}

