/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.model.ReplicationRunState;
import software.amazon.awssdk.services.sms.model.ReplicationRunType;
import software.amazon.awssdk.services.sms.transform.ReplicationRunMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationRun
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicationRun> {
    private final String replicationRunId;
    private final String state;
    private final String type;
    private final String statusMessage;
    private final String amiId;
    private final Instant scheduledStartTime;
    private final Instant completedTime;
    private final String description;

    private ReplicationRun(BuilderImpl builder) {
        this.replicationRunId = builder.replicationRunId;
        this.state = builder.state;
        this.type = builder.type;
        this.statusMessage = builder.statusMessage;
        this.amiId = builder.amiId;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.completedTime = builder.completedTime;
        this.description = builder.description;
    }

    public String replicationRunId() {
        return this.replicationRunId;
    }

    public ReplicationRunState state() {
        return ReplicationRunState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ReplicationRunType type() {
        return ReplicationRunType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String amiId() {
        return this.amiId;
    }

    public Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    public Instant completedTime() {
        return this.completedTime;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRun)) {
            return false;
        }
        ReplicationRun other = (ReplicationRun)obj;
        return Objects.equals(this.replicationRunId(), other.replicationRunId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.scheduledStartTime(), other.scheduledStartTime()) && Objects.equals(this.completedTime(), other.completedTime()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationRun").add("ReplicationRunId", (Object)this.replicationRunId()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("AmiId", (Object)this.amiId()).add("ScheduledStartTime", (Object)this.scheduledStartTime()).add("CompletedTime", (Object)this.completedTime()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationRunId": {
                return Optional.ofNullable(clazz.cast(this.replicationRunId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "amiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "scheduledStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledStartTime()));
            }
            case "completedTime": {
                return Optional.ofNullable(clazz.cast(this.completedTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationRunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationRunId;
        private String state;
        private String type;
        private String statusMessage;
        private String amiId;
        private Instant scheduledStartTime;
        private Instant completedTime;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRun model) {
            this.replicationRunId(model.replicationRunId);
            this.state(model.state);
            this.type(model.type);
            this.statusMessage(model.statusMessage);
            this.amiId(model.amiId);
            this.scheduledStartTime(model.scheduledStartTime);
            this.completedTime(model.completedTime);
            this.description(model.description);
        }

        public final String getReplicationRunId() {
            return this.replicationRunId;
        }

        @Override
        public final Builder replicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
            return this;
        }

        public final void setReplicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplicationRunState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReplicationRunType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final Instant getScheduledStartTime() {
            return this.scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        public final Instant getCompletedTime() {
            return this.completedTime;
        }

        @Override
        public final Builder completedTime(Instant completedTime) {
            this.completedTime = completedTime;
            return this;
        }

        public final void setCompletedTime(Instant completedTime) {
            this.completedTime = completedTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ReplicationRun build() {
            return new ReplicationRun(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationRun> {
        public Builder replicationRunId(String var1);

        public Builder state(String var1);

        public Builder state(ReplicationRunState var1);

        public Builder type(String var1);

        public Builder type(ReplicationRunType var1);

        public Builder statusMessage(String var1);

        public Builder amiId(String var1);

        public Builder scheduledStartTime(Instant var1);

        public Builder completedTime(Instant var1);

        public Builder description(String var1);
    }
}

