/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.services.sms.model.ReplicationJobState;
import software.amazon.awssdk.services.sms.model.ReplicationRun;
import software.amazon.awssdk.services.sms.model.ReplicationRunListCopier;
import software.amazon.awssdk.services.sms.model.ServerType;
import software.amazon.awssdk.services.sms.model.VmServer;
import software.amazon.awssdk.services.sms.transform.ReplicationJobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationJob
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicationJob> {
    private final String replicationJobId;
    private final String serverId;
    private final String serverType;
    private final VmServer vmServer;
    private final Instant seedReplicationTime;
    private final Integer frequency;
    private final Instant nextReplicationRunStartTime;
    private final String licenseType;
    private final String roleName;
    private final String latestAmiId;
    private final String state;
    private final String statusMessage;
    private final String description;
    private final List<ReplicationRun> replicationRunList;

    private ReplicationJob(BuilderImpl builder) {
        this.replicationJobId = builder.replicationJobId;
        this.serverId = builder.serverId;
        this.serverType = builder.serverType;
        this.vmServer = builder.vmServer;
        this.seedReplicationTime = builder.seedReplicationTime;
        this.frequency = builder.frequency;
        this.nextReplicationRunStartTime = builder.nextReplicationRunStartTime;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.latestAmiId = builder.latestAmiId;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.description = builder.description;
        this.replicationRunList = builder.replicationRunList;
    }

    public String replicationJobId() {
        return this.replicationJobId;
    }

    public String serverId() {
        return this.serverId;
    }

    public ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public String serverTypeAsString() {
        return this.serverType;
    }

    public VmServer vmServer() {
        return this.vmServer;
    }

    public Instant seedReplicationTime() {
        return this.seedReplicationTime;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public Instant nextReplicationRunStartTime() {
        return this.nextReplicationRunStartTime;
    }

    public LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public String roleName() {
        return this.roleName;
    }

    public String latestAmiId() {
        return this.latestAmiId;
    }

    public ReplicationJobState state() {
        return ReplicationJobState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String description() {
        return this.description;
    }

    public List<ReplicationRun> replicationRunList() {
        return this.replicationRunList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.seedReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextReplicationRunStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationRunList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob other = (ReplicationJob)obj;
        return Objects.equals(this.replicationJobId(), other.replicationJobId()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.vmServer(), other.vmServer()) && Objects.equals(this.seedReplicationTime(), other.seedReplicationTime()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.nextReplicationRunStartTime(), other.nextReplicationRunStartTime()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.latestAmiId(), other.latestAmiId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.replicationRunList(), other.replicationRunList());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationJob").add("ReplicationJobId", (Object)this.replicationJobId()).add("ServerId", (Object)this.serverId()).add("ServerType", (Object)this.serverTypeAsString()).add("VmServer", (Object)this.vmServer()).add("SeedReplicationTime", (Object)this.seedReplicationTime()).add("Frequency", (Object)this.frequency()).add("NextReplicationRunStartTime", (Object)this.nextReplicationRunStartTime()).add("LicenseType", (Object)this.licenseTypeAsString()).add("RoleName", (Object)this.roleName()).add("LatestAmiId", (Object)this.latestAmiId()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Description", (Object)this.description()).add("ReplicationRunList", this.replicationRunList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJobId": {
                return Optional.ofNullable(clazz.cast(this.replicationJobId()));
            }
            case "serverId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "vmServer": {
                return Optional.ofNullable(clazz.cast(this.vmServer()));
            }
            case "seedReplicationTime": {
                return Optional.ofNullable(clazz.cast(this.seedReplicationTime()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "nextReplicationRunStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextReplicationRunStartTime()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "latestAmiId": {
                return Optional.ofNullable(clazz.cast(this.latestAmiId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "replicationRunList": {
                return Optional.ofNullable(clazz.cast(this.replicationRunList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationJobId;
        private String serverId;
        private String serverType;
        private VmServer vmServer;
        private Instant seedReplicationTime;
        private Integer frequency;
        private Instant nextReplicationRunStartTime;
        private String licenseType;
        private String roleName;
        private String latestAmiId;
        private String state;
        private String statusMessage;
        private String description;
        private List<ReplicationRun> replicationRunList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationJob model) {
            this.replicationJobId(model.replicationJobId);
            this.serverId(model.serverId);
            this.serverType(model.serverType);
            this.vmServer(model.vmServer);
            this.seedReplicationTime(model.seedReplicationTime);
            this.frequency(model.frequency);
            this.nextReplicationRunStartTime(model.nextReplicationRunStartTime);
            this.licenseType(model.licenseType);
            this.roleName(model.roleName);
            this.latestAmiId(model.latestAmiId);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.description(model.description);
            this.replicationRunList(model.replicationRunList);
        }

        public final String getReplicationJobId() {
            return this.replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getServerType() {
            return this.serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final VmServer.Builder getVmServer() {
            return this.vmServer != null ? this.vmServer.toBuilder() : null;
        }

        @Override
        public final Builder vmServer(VmServer vmServer) {
            this.vmServer = vmServer;
            return this;
        }

        public final void setVmServer(VmServer.BuilderImpl vmServer) {
            this.vmServer = vmServer != null ? vmServer.build() : null;
        }

        public final Instant getSeedReplicationTime() {
            return this.seedReplicationTime;
        }

        @Override
        public final Builder seedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
            return this;
        }

        public final void setSeedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Instant getNextReplicationRunStartTime() {
            return this.nextReplicationRunStartTime;
        }

        @Override
        public final Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
            return this;
        }

        public final void setNextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getLatestAmiId() {
            return this.latestAmiId;
        }

        @Override
        public final Builder latestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
            return this;
        }

        public final void setLatestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplicationJobState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ReplicationRun.Builder> getReplicationRunList() {
            return this.replicationRunList != null ? (Collection)this.replicationRunList.stream().map(ReplicationRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationRunList(Collection<ReplicationRun> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copy(replicationRunList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(ReplicationRun ... replicationRunList) {
            this.replicationRunList(Arrays.asList(replicationRunList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(Consumer<ReplicationRun.Builder> ... replicationRunList) {
            this.replicationRunList(Stream.of(replicationRunList).map(c -> (ReplicationRun)((ReplicationRun.Builder)ReplicationRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationRunList(Collection<ReplicationRun.BuilderImpl> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copyFromBuilder(replicationRunList);
        }

        public ReplicationJob build() {
            return new ReplicationJob(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationJob> {
        public Builder replicationJobId(String var1);

        public Builder serverId(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder vmServer(VmServer var1);

        default public Builder vmServer(Consumer<VmServer.Builder> vmServer) {
            return this.vmServer((VmServer)((VmServer.Builder)VmServer.builder().applyMutation(vmServer)).build());
        }

        public Builder seedReplicationTime(Instant var1);

        public Builder frequency(Integer var1);

        public Builder nextReplicationRunStartTime(Instant var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder roleName(String var1);

        public Builder latestAmiId(String var1);

        public Builder state(String var1);

        public Builder state(ReplicationJobState var1);

        public Builder statusMessage(String var1);

        public Builder description(String var1);

        public Builder replicationRunList(Collection<ReplicationRun> var1);

        public Builder replicationRunList(ReplicationRun ... var1);

        public Builder replicationRunList(Consumer<ReplicationRun.Builder> ... var1);
    }
}

