/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ReplicationJob;
import software.amazon.awssdk.services.sms.model.ReplicationJobListCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReplicationJobsResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetReplicationJobsResponse> {
    private final List<ReplicationJob> replicationJobList;
    private final String nextToken;

    private GetReplicationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJobList = builder.replicationJobList;
        this.nextToken = builder.nextToken;
    }

    public List<ReplicationJob> replicationJobList() {
        return this.replicationJobList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationJobsResponse)) {
            return false;
        }
        GetReplicationJobsResponse other = (GetReplicationJobsResponse)((Object)obj);
        return Objects.equals(this.replicationJobList(), other.replicationJobList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReplicationJobsResponse").add("ReplicationJobList", this.replicationJobList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJobList": {
                return Optional.ofNullable(clazz.cast(this.replicationJobList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<ReplicationJob> replicationJobList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationJobsResponse model) {
            super(model);
            this.replicationJobList(model.replicationJobList);
            this.nextToken(model.nextToken);
        }

        public final Collection<ReplicationJob.Builder> getReplicationJobList() {
            return this.replicationJobList != null ? (Collection)this.replicationJobList.stream().map(ReplicationJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationJobList(Collection<ReplicationJob> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copy(replicationJobList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationJobList(ReplicationJob ... replicationJobList) {
            this.replicationJobList(Arrays.asList(replicationJobList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationJobList(Consumer<ReplicationJob.Builder> ... replicationJobList) {
            this.replicationJobList(Stream.of(replicationJobList).map(c -> (ReplicationJob)((ReplicationJob.Builder)ReplicationJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationJobList(Collection<ReplicationJob.BuilderImpl> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copyFromBuilder(replicationJobList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetReplicationJobsResponse build() {
            return new GetReplicationJobsResponse(this);
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    CopyableBuilder<Builder, GetReplicationJobsResponse> {
        public Builder replicationJobList(Collection<ReplicationJob> var1);

        public Builder replicationJobList(ReplicationJob ... var1);

        public Builder replicationJobList(Consumer<ReplicationJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

