/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.Connector;
import software.amazon.awssdk.services.sms.model.ConnectorListCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectorsResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetConnectorsResponse> {
    private final List<Connector> connectorList;
    private final String nextToken;

    private GetConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorList = builder.connectorList;
        this.nextToken = builder.nextToken;
    }

    public List<Connector> connectorList() {
        return this.connectorList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorsResponse)) {
            return false;
        }
        GetConnectorsResponse other = (GetConnectorsResponse)((Object)obj);
        return Objects.equals(this.connectorList(), other.connectorList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetConnectorsResponse").add("ConnectorList", this.connectorList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorList": {
                return Optional.ofNullable(clazz.cast(this.connectorList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<Connector> connectorList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorsResponse model) {
            super(model);
            this.connectorList(model.connectorList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Connector.Builder> getConnectorList() {
            return this.connectorList != null ? (Collection)this.connectorList.stream().map(Connector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectorList(Collection<Connector> connectorList) {
            this.connectorList = ConnectorListCopier.copy(connectorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorList(Connector ... connectorList) {
            this.connectorList(Arrays.asList(connectorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorList(Consumer<Connector.Builder> ... connectorList) {
            this.connectorList(Stream.of(connectorList).map(c -> (Connector)((Connector.Builder)Connector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectorList(Collection<Connector.BuilderImpl> connectorList) {
            this.connectorList = ConnectorListCopier.copyFromBuilder(connectorList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConnectorsResponse build() {
            return new GetConnectorsResponse(this);
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    CopyableBuilder<Builder, GetConnectorsResponse> {
        public Builder connectorList(Collection<Connector> var1);

        public Builder connectorList(Connector ... var1);

        public Builder connectorList(Consumer<Connector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

