/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ConnectorCapability;
import software.amazon.awssdk.services.sms.model.ConnectorCapabilityListCopier;
import software.amazon.awssdk.services.sms.model.ConnectorStatus;
import software.amazon.awssdk.services.sms.model.VmManagerType;
import software.amazon.awssdk.services.sms.transform.ConnectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connector
implements StructuredPojo,
ToCopyableBuilder<Builder, Connector> {
    private final String connectorId;
    private final String version;
    private final String status;
    private final List<String> capabilityList;
    private final String vmManagerName;
    private final String vmManagerType;
    private final String vmManagerId;
    private final String ipAddress;
    private final String macAddress;
    private final Instant associatedOn;

    private Connector(BuilderImpl builder) {
        this.connectorId = builder.connectorId;
        this.version = builder.version;
        this.status = builder.status;
        this.capabilityList = builder.capabilityList;
        this.vmManagerName = builder.vmManagerName;
        this.vmManagerType = builder.vmManagerType;
        this.vmManagerId = builder.vmManagerId;
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
        this.associatedOn = builder.associatedOn;
    }

    public String connectorId() {
        return this.connectorId;
    }

    public String version() {
        return this.version;
    }

    public ConnectorStatus status() {
        return ConnectorStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<ConnectorCapability> capabilityList() {
        return TypeConverter.convert(this.capabilityList, ConnectorCapability::fromValue);
    }

    public List<String> capabilityListAsStrings() {
        return this.capabilityList;
    }

    public String vmManagerName() {
        return this.vmManagerName;
    }

    public VmManagerType vmManagerType() {
        return VmManagerType.fromValue(this.vmManagerType);
    }

    public String vmManagerTypeAsString() {
        return this.vmManagerType;
    }

    public String vmManagerId() {
        return this.vmManagerId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public Instant associatedOn() {
        return this.associatedOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityListAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedOn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.capabilityListAsStrings(), other.capabilityListAsStrings()) && Objects.equals(this.vmManagerName(), other.vmManagerName()) && Objects.equals(this.vmManagerTypeAsString(), other.vmManagerTypeAsString()) && Objects.equals(this.vmManagerId(), other.vmManagerId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.associatedOn(), other.associatedOn());
    }

    public String toString() {
        return ToString.builder((String)"Connector").add("ConnectorId", (Object)this.connectorId()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("CapabilityList", this.capabilityListAsStrings()).add("VmManagerName", (Object)this.vmManagerName()).add("VmManagerType", (Object)this.vmManagerTypeAsString()).add("VmManagerId", (Object)this.vmManagerId()).add("IpAddress", (Object)this.ipAddress()).add("MacAddress", (Object)this.macAddress()).add("AssociatedOn", (Object)this.associatedOn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "capabilityList": {
                return Optional.ofNullable(clazz.cast(this.capabilityListAsStrings()));
            }
            case "vmManagerName": {
                return Optional.ofNullable(clazz.cast(this.vmManagerName()));
            }
            case "vmManagerType": {
                return Optional.ofNullable(clazz.cast(this.vmManagerTypeAsString()));
            }
            case "vmManagerId": {
                return Optional.ofNullable(clazz.cast(this.vmManagerId()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "associatedOn": {
                return Optional.ofNullable(clazz.cast(this.associatedOn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorId;
        private String version;
        private String status;
        private List<String> capabilityList = DefaultSdkAutoConstructList.getInstance();
        private String vmManagerName;
        private String vmManagerType;
        private String vmManagerId;
        private String ipAddress;
        private String macAddress;
        private Instant associatedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(Connector model) {
            this.connectorId(model.connectorId);
            this.version(model.version);
            this.status(model.status);
            this.capabilityListWithStrings(model.capabilityList);
            this.vmManagerName(model.vmManagerName);
            this.vmManagerType(model.vmManagerType);
            this.vmManagerId(model.vmManagerId);
            this.ipAddress(model.ipAddress);
            this.macAddress(model.macAddress);
            this.associatedOn(model.associatedOn);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getCapabilityList() {
            return this.capabilityList;
        }

        @Override
        public final Builder capabilityListWithStrings(Collection<String> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copy(capabilityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilityListWithStrings(String ... capabilityList) {
            this.capabilityListWithStrings(Arrays.asList(capabilityList));
            return this;
        }

        @Override
        public final Builder capabilityList(Collection<ConnectorCapability> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copyEnumToString(capabilityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilityList(ConnectorCapability ... capabilityList) {
            this.capabilityList(Arrays.asList(capabilityList));
            return this;
        }

        public final void setCapabilityList(Collection<String> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copy(capabilityList);
        }

        public final String getVmManagerName() {
            return this.vmManagerName;
        }

        @Override
        public final Builder vmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
            return this;
        }

        public final void setVmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
        }

        public final String getVmManagerType() {
            return this.vmManagerType;
        }

        @Override
        public final Builder vmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
            return this;
        }

        @Override
        public final Builder vmManagerType(VmManagerType vmManagerType) {
            this.vmManagerType(vmManagerType.toString());
            return this;
        }

        public final void setVmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
        }

        public final String getVmManagerId() {
            return this.vmManagerId;
        }

        @Override
        public final Builder vmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
            return this;
        }

        public final void setVmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final Instant getAssociatedOn() {
            return this.associatedOn;
        }

        @Override
        public final Builder associatedOn(Instant associatedOn) {
            this.associatedOn = associatedOn;
            return this;
        }

        public final void setAssociatedOn(Instant associatedOn) {
            this.associatedOn = associatedOn;
        }

        public Connector build() {
            return new Connector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Connector> {
        public Builder connectorId(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(ConnectorStatus var1);

        public Builder capabilityListWithStrings(Collection<String> var1);

        public Builder capabilityListWithStrings(String ... var1);

        public Builder capabilityList(Collection<ConnectorCapability> var1);

        public Builder capabilityList(ConnectorCapability ... var1);

        public Builder vmManagerName(String var1);

        public Builder vmManagerType(String var1);

        public Builder vmManagerType(VmManagerType var1);

        public Builder vmManagerId(String var1);

        public Builder ipAddress(String var1);

        public Builder macAddress(String var1);

        public Builder associatedOn(Instant var1);
    }
}

