/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorResponse;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.InternalErrorException;
import software.amazon.awssdk.services.sms.model.InvalidParameterException;
import software.amazon.awssdk.services.sms.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sms.model.NoConnectorsAvailableException;
import software.amazon.awssdk.services.sms.model.OperationNotPermittedException;
import software.amazon.awssdk.services.sms.model.ReplicationJobAlreadyExistsException;
import software.amazon.awssdk.services.sms.model.ReplicationJobNotFoundException;
import software.amazon.awssdk.services.sms.model.ReplicationRunLimitExceededException;
import software.amazon.awssdk.services.sms.model.ServerCannotBeReplicatedException;
import software.amazon.awssdk.services.sms.model.SmsException;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse;
import software.amazon.awssdk.services.sms.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobResponse;
import software.amazon.awssdk.services.sms.transform.CreateReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.CreateReplicationJobResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteReplicationJobResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteServerCatalogResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.DisassociateConnectorRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DisassociateConnectorResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.GetConnectorsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetConnectorsResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationJobsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationJobsResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationRunsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationRunsResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.GetServersRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetServersResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandReplicationRunRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandReplicationRunResponseUnmarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateReplicationJobResponseUnmarshaller;

@SdkInternalApi
final class DefaultSmsClient
implements SmsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSmsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "sms";
    }

    @Override
    public CreateReplicationJobResponse createReplicationJob(CreateReplicationJobRequest createReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ServerCannotBeReplicatedException, ReplicationJobAlreadyExistsException, NoConnectorsAvailableException, InternalErrorException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateReplicationJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationJobRequest).withMarshaller((Marshaller)new CreateReplicationJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteReplicationJobResponse deleteReplicationJob(DeleteReplicationJobRequest deleteReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationJobNotFoundException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteReplicationJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationJobRequest).withMarshaller((Marshaller)new DeleteReplicationJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteServerCatalogResponse deleteServerCatalog(DeleteServerCatalogRequest deleteServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServerCatalogResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerCatalogRequest).withMarshaller((Marshaller)new DeleteServerCatalogRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateConnectorResponse disassociateConnector(DisassociateConnectorRequest disassociateConnectorRequest) throws MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateConnectorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DisassociateConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateConnectorRequest).withMarshaller((Marshaller)new DisassociateConnectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetConnectorsResponse getConnectors(GetConnectorsRequest getConnectorsRequest) throws UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConnectorsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConnectorsRequest).withMarshaller((Marshaller)new GetConnectorsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetReplicationJobsResponse getReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReplicationJobsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetReplicationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReplicationJobsRequest).withMarshaller((Marshaller)new GetReplicationJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetReplicationRunsResponse getReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReplicationRunsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetReplicationRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReplicationRunsRequest).withMarshaller((Marshaller)new GetReplicationRunsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetServersResponse getServers(GetServersRequest getServersRequest) throws UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetServersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServersRequest).withMarshaller((Marshaller)new GetServersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ImportServerCatalogResponse importServerCatalog(ImportServerCatalogRequest importServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, NoConnectorsAvailableException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportServerCatalogResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ImportServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importServerCatalogRequest).withMarshaller((Marshaller)new ImportServerCatalogRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartOnDemandReplicationRunResponse startOnDemandReplicationRun(StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationRunLimitExceededException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartOnDemandReplicationRunResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartOnDemandReplicationRunResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startOnDemandReplicationRunRequest).withMarshaller((Marshaller)new StartOnDemandReplicationRunRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateReplicationJobResponse updateReplicationJob(UpdateReplicationJobRequest updateReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, OperationNotPermittedException, UnauthorizedOperationException, ServerCannotBeReplicatedException, ReplicationJobNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, SmsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReplicationJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReplicationJobRequest).withMarshaller((Marshaller)new UpdateReplicationJobRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(SmsException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationJobAlreadyExistsException").withModeledClass(ReplicationJobAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingRequiredParameterException").withModeledClass(MissingRequiredParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerCannotBeReplicatedException").withModeledClass(ServerCannotBeReplicatedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationJobNotFoundException").withModeledClass(ReplicationJobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationRunLimitExceededException").withModeledClass(ReplicationRunLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperationException").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalError").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoConnectorsAvailableException").withModeledClass(NoConnectorsAvailableException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

