/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.rpcv2.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.BaseAwsStructuredJsonFactory;
import software.amazon.awssdk.protocols.json.ErrorCodeParser;
import software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonErrorCodeParser;
import software.amazon.awssdk.protocols.rpcv2.internal.SdkRpcV2CborGenerator;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORFactory;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORFactoryBuilder;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORGenerator;

@SdkInternalApi
public final class SdkStructuredRpcV2CborFactory {
    private static final CBORFactory CBOR_FACTORY = new CBORFactoryBuilder(new CBORFactory()).enable(CBORGenerator.Feature.WRITE_MINIMAL_INTS).enable(CBORGenerator.Feature.WRITE_MINIMAL_DOUBLES).build();
    public static final BaseAwsStructuredJsonFactory SDK_CBOR_FACTORY = new BaseAwsStructuredJsonFactory((JsonFactory)CBOR_FACTORY){

        protected StructuredJsonGenerator createWriter(JsonFactory jsonFactory, String contentType) {
            return new SdkRpcV2CborGenerator(jsonFactory, contentType);
        }

        public CBORFactory getJsonFactory() {
            return CBOR_FACTORY;
        }

        public ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
            String errorCodeField = customErrorCodeFieldName == null ? "__type" : customErrorCodeFieldName;
            return new JsonErrorCodeParser(errorCodeField);
        }
    };

    private SdkStructuredRpcV2CborFactory() {
    }
}

