/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.rpcv2.internal;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.protocols.core.NumberToInstant;
import software.amazon.awssdk.protocols.core.StringToInstant;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.json.internal.unmarshall.DefaultJsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonProtocolUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerContext;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;

@SdkInternalApi
public final class SdkRpcV2CborUnmarshaller {
    private SdkRpcV2CborUnmarshaller() {
    }

    public static JsonUnmarshallerRegistry timestampFormatRegistryFactory(Map<MarshallLocation, TimestampFormatTrait.Format> formats) {
        DefaultJsonUnmarshallerRegistry.Builder builder = JsonProtocolUnmarshaller.createSharedRegistry().toBuilder();
        StringToInstant instantStringToValue = StringToInstant.create(formats.isEmpty() ? new EnumMap(MarshallLocation.class) : new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(formats));
        NumberToInstant instantNumberToValue = NumberToInstant.create(formats.isEmpty() ? new EnumMap(MarshallLocation.class) : new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(formats));
        SimpleTypeInstantJsonUnmarshaller payloadUnmarshaller = new SimpleTypeInstantJsonUnmarshaller((StringToValueConverter.StringToValue)instantStringToValue, instantNumberToValue);
        builder.payloadUnmarshaller(MarshallingType.INSTANT, payloadUnmarshaller);
        return SdkRpcV2CborUnmarshaller.setPayloadOverrides(builder).build();
    }

    public static DefaultJsonUnmarshallerRegistry.Builder setPayloadOverrides(DefaultJsonUnmarshallerRegistry.Builder builder) {
        builder.payloadUnmarshaller(MarshallingType.INTEGER, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::intValue, StringToValueConverter.TO_INTEGER)).payloadUnmarshaller(MarshallingType.LONG, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::longValue, StringToValueConverter.TO_LONG)).payloadUnmarshaller(MarshallingType.BYTE, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::byteValue, StringToValueConverter.TO_BYTE)).payloadUnmarshaller(MarshallingType.SHORT, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::shortValue, StringToValueConverter.TO_SHORT)).payloadUnmarshaller(MarshallingType.FLOAT, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::floatValue, StringToValueConverter.TO_FLOAT)).payloadUnmarshaller(MarshallingType.DOUBLE, SdkRpcV2CborUnmarshaller.forEmbeddable(Number.class, Number::doubleValue, StringToValueConverter.TO_DOUBLE)).payloadUnmarshaller(MarshallingType.BIG_DECIMAL, SdkRpcV2CborUnmarshaller.forEmbeddable(BigDecimal.class, StringToValueConverter.TO_BIG_DECIMAL)).payloadUnmarshaller(MarshallingType.BOOLEAN, SdkRpcV2CborUnmarshaller.forEmbeddable(Boolean.class, StringToValueConverter.TO_BOOLEAN));
        return builder;
    }

    private static <T, V> EmbeddableTypeTransformingJsonUnmarshaller<T, V> forEmbeddable(Class<V> embeddedType, Function<V, T> transformer, StringToValueConverter.StringToValue<T> stringToValue) {
        return new EmbeddableTypeTransformingJsonUnmarshaller(embeddedType, transformer, stringToValue);
    }

    private static <T> EmbeddableTypeTransformingJsonUnmarshaller<T, T> forEmbeddable(Class<T> embeddedType, StringToValueConverter.StringToValue<T> stringToValue) {
        return new EmbeddableTypeTransformingJsonUnmarshaller(embeddedType, Function.identity(), stringToValue);
    }

    private static class SimpleTypeInstantJsonUnmarshaller<T>
    implements JsonUnmarshaller<T> {
        private final StringToValueConverter.StringToValue<T> stringToValue;
        private final NumberToInstant numberToInstant;

        private SimpleTypeInstantJsonUnmarshaller(StringToValueConverter.StringToValue<T> stringToValue, NumberToInstant numberToInstant) {
            this.stringToValue = stringToValue;
            this.numberToInstant = numberToInstant;
        }

        public T unmarshall(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<T> field) {
            if (jsonContent == null || jsonContent.isNull()) {
                return null;
            }
            String text = null;
            if (jsonContent.isEmbeddedObject()) {
                Object embedded = jsonContent.asEmbeddedObject();
                if (embedded == null) {
                    return null;
                }
                if (Number.class.isAssignableFrom(embedded.getClass())) {
                    return (T)this.numberToInstant.convert((Number)embedded, field);
                }
                text = embedded.toString();
            }
            if (text == null) {
                text = jsonContent.text();
            }
            return (T)this.stringToValue.convert(text, field);
        }
    }

    private static class EmbeddableTypeTransformingJsonUnmarshaller<T, V>
    implements JsonUnmarshaller<T> {
        private final StringToValueConverter.StringToValue<T> stringToValue;
        private final Class<V> embeddedType;
        private final Function<V, T> typeConverter;

        private EmbeddableTypeTransformingJsonUnmarshaller(Class<V> embeddedType, Function<V, T> typeConverter, StringToValueConverter.StringToValue<T> stringToValue) {
            this.stringToValue = stringToValue;
            this.typeConverter = typeConverter;
            this.embeddedType = embeddedType;
        }

        public T unmarshall(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<T> field) {
            if (jsonContent == null || jsonContent.isNull()) {
                return null;
            }
            String text = null;
            if (jsonContent.isEmbeddedObject()) {
                Object embedded = jsonContent.asEmbeddedObject();
                if (embedded == null) {
                    return null;
                }
                if (this.embeddedType.isAssignableFrom(embedded.getClass())) {
                    return this.typeConverter.apply(embedded);
                }
                text = embedded.toString();
            }
            if (text == null) {
                text = jsonContent.text();
            }
            return (T)this.stringToValue.convert(text, field);
        }
    }
}

