/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppStatus;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationAppMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationAppMetadata> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(SimulationAppMetadata.getter(SimulationAppMetadata::domain)).setter(SimulationAppMetadata.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SimulationAppMetadata.getter(SimulationAppMetadata::name)).setter(SimulationAppMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SIMULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Simulation").getter(SimulationAppMetadata.getter(SimulationAppMetadata::simulation)).setter(SimulationAppMetadata.setter(Builder::simulation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SimulationAppMetadata.getter(SimulationAppMetadata::statusAsString)).setter(SimulationAppMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetStatus").getter(SimulationAppMetadata.getter(SimulationAppMetadata::targetStatusAsString)).setter(SimulationAppMetadata.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD, SIMULATION_FIELD, STATUS_FIELD, TARGET_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SimulationAppMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String name;
    private final String simulation;
    private final String status;
    private final String targetStatus;

    private SimulationAppMetadata(BuilderImpl builder) {
        this.domain = builder.domain;
        this.name = builder.name;
        this.simulation = builder.simulation;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    public final String domain() {
        return this.domain;
    }

    public final String name() {
        return this.name;
    }

    public final String simulation() {
        return this.simulation;
    }

    public final SimulationAppStatus status() {
        return SimulationAppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SimulationAppTargetStatus targetStatus() {
        return SimulationAppTargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationAppMetadata)) {
            return false;
        }
        SimulationAppMetadata other = (SimulationAppMetadata)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.simulation(), other.simulation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SimulationAppMetadata").add("Domain", (Object)this.domain()).add("Name", (Object)this.name()).add("Simulation", (Object)this.simulation()).add("Status", (Object)this.statusAsString()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Simulation": {
                return Optional.ofNullable(clazz.cast(this.simulation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetStatus", TARGET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationAppMetadata, T> g) {
        return obj -> g.apply((SimulationAppMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String name;
        private String simulation;
        private String status;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationAppMetadata model) {
            this.domain(model.domain);
            this.name(model.name);
            this.simulation(model.simulation);
            this.status(model.status);
            this.targetStatus(model.targetStatus);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSimulation() {
            return this.simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationAppTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public SimulationAppMetadata build() {
            return new SimulationAppMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationAppMetadata> {
        public Builder domain(String var1);

        public Builder name(String var1);

        public Builder simulation(String var1);

        public Builder status(String var1);

        public Builder status(SimulationAppStatus var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(SimulationAppTargetStatus var1);
    }
}

