/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.simspaceweaver.model.Domain;
import software.amazon.awssdk.services.simspaceweaver.model.DomainListCopier;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationClock;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationClockListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiveSimulationState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveSimulationState> {
    private static final SdkField<List<SimulationClock>> CLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Clocks").getter(LiveSimulationState.getter(LiveSimulationState::clocks)).setter(LiveSimulationState.setter(Builder::clocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationClock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Domain>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(LiveSimulationState.getter(LiveSimulationState::domains)).setter(LiveSimulationState.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Domain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOCKS_FIELD, DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiveSimulationState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SimulationClock> clocks;
    private final List<Domain> domains;

    private LiveSimulationState(BuilderImpl builder) {
        this.clocks = builder.clocks;
        this.domains = builder.domains;
    }

    public final boolean hasClocks() {
        return this.clocks != null && !(this.clocks instanceof SdkAutoConstructList);
    }

    public final List<SimulationClock> clocks() {
        return this.clocks;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<Domain> domains() {
        return this.domains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClocks() ? this.clocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveSimulationState)) {
            return false;
        }
        LiveSimulationState other = (LiveSimulationState)obj;
        return this.hasClocks() == other.hasClocks() && Objects.equals(this.clocks(), other.clocks()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains());
    }

    public final String toString() {
        return ToString.builder((String)"LiveSimulationState").add("Clocks", this.hasClocks() ? this.clocks() : null).add("Domains", this.hasDomains() ? this.domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clocks": {
                return Optional.ofNullable(clazz.cast(this.clocks()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Clocks", CLOCKS_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveSimulationState, T> g) {
        return obj -> g.apply((LiveSimulationState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SimulationClock> clocks = DefaultSdkAutoConstructList.getInstance();
        private List<Domain> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LiveSimulationState model) {
            this.clocks(model.clocks);
            this.domains(model.domains);
        }

        public final List<SimulationClock.Builder> getClocks() {
            List<SimulationClock.Builder> result = SimulationClockListCopier.copyToBuilder(this.clocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClocks(Collection<SimulationClock.BuilderImpl> clocks) {
            this.clocks = SimulationClockListCopier.copyFromBuilder(clocks);
        }

        @Override
        public final Builder clocks(Collection<SimulationClock> clocks) {
            this.clocks = SimulationClockListCopier.copy(clocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clocks(SimulationClock ... clocks) {
            this.clocks(Arrays.asList(clocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clocks(Consumer<SimulationClock.Builder> ... clocks) {
            this.clocks(Stream.of(clocks).map(c -> (SimulationClock)((SimulationClock.Builder)SimulationClock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Domain.Builder> getDomains() {
            List<Domain.Builder> result = DomainListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<Domain.BuilderImpl> domains) {
            this.domains = DomainListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<Domain.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (Domain)((Domain.Builder)Domain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LiveSimulationState build() {
            return new LiveSimulationState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveSimulationState> {
        public Builder clocks(Collection<SimulationClock> var1);

        public Builder clocks(SimulationClock ... var1);

        public Builder clocks(Consumer<SimulationClock.Builder> ... var1);

        public Builder domains(Collection<Domain> var1);

        public Builder domains(Domain ... var1);

        public Builder domains(Consumer<Domain.Builder> ... var1);
    }
}

