/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverAsyncClient;
import software.amazon.awssdk.services.simspaceweaver.internal.UserAgentUtils;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse;

public class ListAppsPublisher
implements SdkPublisher<ListAppsResponse> {
    private final SimSpaceWeaverAsyncClient client;
    private final ListAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppsPublisher(SimSpaceWeaverAsyncClient client, ListAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppsPublisher(SimSpaceWeaverAsyncClient client, ListAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppsResponseFetcher
    implements AsyncPageFetcher<ListAppsResponse> {
        private ListAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppsResponse> nextPage(ListAppsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsPublisher.this.client.listApps(ListAppsPublisher.this.firstRequest);
            }
            return ListAppsPublisher.this.client.listApps((ListAppsRequest)((Object)ListAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

