/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.signin.auth.scheme.SigninAuthSchemeParams;
import software.amazon.awssdk.services.signin.auth.scheme.SigninAuthSchemeProvider;

@SdkInternalApi
public final class DefaultSigninAuthSchemeProvider
implements SigninAuthSchemeProvider {
    private static final DefaultSigninAuthSchemeProvider DEFAULT = new DefaultSigninAuthSchemeProvider();

    private DefaultSigninAuthSchemeProvider() {
    }

    public static DefaultSigninAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(SigninAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "CreateOAuth2Token": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"signin").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

