/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signin.model.AccessToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOAuth2TokenResponseBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateOAuth2TokenResponseBody> {
    private static final SdkField<AccessToken> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessToken").getter(CreateOAuth2TokenResponseBody.getter(CreateOAuth2TokenResponseBody::accessToken)).setter(CreateOAuth2TokenResponseBody.setter(Builder::accessToken)).constructor(AccessToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenType").getter(CreateOAuth2TokenResponseBody.getter(CreateOAuth2TokenResponseBody::tokenType)).setter(CreateOAuth2TokenResponseBody.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenType").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiresIn").getter(CreateOAuth2TokenResponseBody.getter(CreateOAuth2TokenResponseBody::expiresIn)).setter(CreateOAuth2TokenResponseBody.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(CreateOAuth2TokenResponseBody.getter(CreateOAuth2TokenResponseBody::refreshToken)).setter(CreateOAuth2TokenResponseBody.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idToken").getter(CreateOAuth2TokenResponseBody.getter(CreateOAuth2TokenResponseBody::idToken)).setter(CreateOAuth2TokenResponseBody.setter(Builder::idToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, TOKEN_TYPE_FIELD, EXPIRES_IN_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOAuth2TokenResponseBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AccessToken accessToken;
    private final String tokenType;
    private final Integer expiresIn;
    private final String refreshToken;
    private final String idToken;

    private CreateOAuth2TokenResponseBody(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
    }

    public final AccessToken accessToken() {
        return this.accessToken;
    }

    public final String tokenType() {
        return this.tokenType;
    }

    public final Integer expiresIn() {
        return this.expiresIn;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String idToken() {
        return this.idToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.idToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOAuth2TokenResponseBody)) {
            return false;
        }
        CreateOAuth2TokenResponseBody other = (CreateOAuth2TokenResponseBody)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.idToken(), other.idToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOAuth2TokenResponseBody").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("TokenType", (Object)this.tokenType()).add("ExpiresIn", (Object)this.expiresIn()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("IdToken", (Object)this.idToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "tokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "idToken": {
                return Optional.ofNullable(clazz.cast(this.idToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("tokenType", TOKEN_TYPE_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("idToken", ID_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOAuth2TokenResponseBody, T> g) {
        return obj -> g.apply((CreateOAuth2TokenResponseBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessToken accessToken;
        private String tokenType;
        private Integer expiresIn;
        private String refreshToken;
        private String idToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOAuth2TokenResponseBody model) {
            this.accessToken(model.accessToken);
            this.tokenType(model.tokenType);
            this.expiresIn(model.expiresIn);
            this.refreshToken(model.refreshToken);
            this.idToken(model.idToken);
        }

        public final AccessToken.Builder getAccessToken() {
            return this.accessToken != null ? this.accessToken.toBuilder() : null;
        }

        public final void setAccessToken(AccessToken.BuilderImpl accessToken) {
            this.accessToken = accessToken != null ? accessToken.build() : null;
        }

        @Override
        public final Builder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public CreateOAuth2TokenResponseBody build() {
            return new CreateOAuth2TokenResponseBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateOAuth2TokenResponseBody> {
        public Builder accessToken(AccessToken var1);

        default public Builder accessToken(Consumer<AccessToken.Builder> accessToken) {
            return this.accessToken((AccessToken)((AccessToken.Builder)AccessToken.builder().applyMutation(accessToken)).build());
        }

        public Builder tokenType(String var1);

        public Builder expiresIn(Integer var1);

        public Builder refreshToken(String var1);

        public Builder idToken(String var1);
    }
}

