/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.services.signin.internal.DpopIdentity;
import software.amazon.awssdk.services.signin.internal.DpopSigner;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DpopAuthScheme
implements AuthScheme<DpopIdentity> {
    public static final String SCHEME_NAME = "DPOP";
    private final IdentityProvider<DpopIdentity> identityProvider;

    private DpopAuthScheme(IdentityProvider<DpopIdentity> identityProvider) {
        this.identityProvider = (IdentityProvider)Validate.paramNotNull(identityProvider, (String)"identityProvider");
    }

    public static DpopAuthScheme create(IdentityProvider<DpopIdentity> identityProvider) {
        return new DpopAuthScheme(identityProvider);
    }

    public String schemeId() {
        return SCHEME_NAME;
    }

    public IdentityProvider<DpopIdentity> identityProvider(IdentityProviders providers) {
        return this.identityProvider;
    }

    public HttpSigner<DpopIdentity> signer() {
        return new DpopSigner();
    }
}

