/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignPayloadResponse extends SignerResponse implements
        ToCopyableBuilder<SignPayloadResponse.Builder, SignPayloadResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(SignPayloadResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobOwner").getter(getter(SignPayloadResponse::jobOwner)).setter(setter(Builder::jobOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(SignPayloadResponse::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SdkBytes> SIGNATURE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("signature").getter(getter(SignPayloadResponse::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_OWNER_FIELD,
            METADATA_FIELD, SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String jobOwner;

    private final Map<String, String> metadata;

    private final SdkBytes signature;

    private SignPayloadResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobOwner = builder.jobOwner;
        this.metadata = builder.metadata;
        this.signature = builder.signature;
    }

    /**
     * <p>
     * Unique identifier of the signing job.
     * </p>
     * 
     * @return Unique identifier of the signing job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The AWS account ID of the job owner.
     * </p>
     * 
     * @return The AWS account ID of the job owner.
     */
    public final String jobOwner() {
        return jobOwner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information including the signing profile ARN and the signing job ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Information including the signing profile ARN and the signing job ID.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * A cryptographic signature.
     * </p>
     * 
     * @return A cryptographic signature.
     */
    public final SdkBytes signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignPayloadResponse)) {
            return false;
        }
        SignPayloadResponse other = (SignPayloadResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobOwner(), other.jobOwner())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata())
                && Objects.equals(signature(), other.signature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignPayloadResponse").add("JobId", jobId()).add("JobOwner", jobOwner())
                .add("Metadata", hasMetadata() ? metadata() : null).add("Signature", signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobOwner":
            return Optional.ofNullable(clazz.cast(jobOwner()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobOwner", JOB_OWNER_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("signature", SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignPayloadResponse, T> g) {
        return obj -> g.apply((SignPayloadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, SignPayloadResponse> {
        /**
         * <p>
         * Unique identifier of the signing job.
         * </p>
         * 
         * @param jobId
         *        Unique identifier of the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The AWS account ID of the job owner.
         * </p>
         * 
         * @param jobOwner
         *        The AWS account ID of the job owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOwner(String jobOwner);

        /**
         * <p>
         * Information including the signing profile ARN and the signing job ID.
         * </p>
         * 
         * @param metadata
         *        Information including the signing profile ARN and the signing job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * A cryptographic signature.
         * </p>
         * 
         * @param signature
         *        A cryptographic signature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(SdkBytes signature);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobOwner;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private SdkBytes signature;

        private BuilderImpl() {
        }

        private BuilderImpl(SignPayloadResponse model) {
            super(model);
            jobId(model.jobId);
            jobOwner(model.jobOwner);
            metadata(model.metadata);
            signature(model.signature);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobOwner() {
            return jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final ByteBuffer getSignature() {
            return signature == null ? null : signature.asByteBuffer();
        }

        public final void setSignature(ByteBuffer signature) {
            signature(signature == null ? null : SdkBytes.fromByteBuffer(signature));
        }

        @Override
        public final Builder signature(SdkBytes signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public SignPayloadResponse build() {
            return new SignPayloadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
