/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRevocationStatusResponse extends SignerResponse implements
        ToCopyableBuilder<GetRevocationStatusResponse.Builder, GetRevocationStatusResponse> {
    private static final SdkField<List<String>> REVOKED_ENTITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("revokedEntities")
            .getter(getter(GetRevocationStatusResponse::revokedEntities))
            .setter(setter(Builder::revokedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVOKED_ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> revokedEntities;

    private GetRevocationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.revokedEntities = builder.revokedEntities;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevokedEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevokedEntities() {
        return revokedEntities != null && !(revokedEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and certificate
     * hashes) supplied as input to the API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevokedEntities} method.
     * </p>
     * 
     * @return A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and
     *         certificate hashes) supplied as input to the API.
     */
    public final List<String> revokedEntities() {
        return revokedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRevokedEntities() ? revokedEntities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevocationStatusResponse)) {
            return false;
        }
        GetRevocationStatusResponse other = (GetRevocationStatusResponse) obj;
        return hasRevokedEntities() == other.hasRevokedEntities() && Objects.equals(revokedEntities(), other.revokedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRevocationStatusResponse")
                .add("RevokedEntities", hasRevokedEntities() ? revokedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revokedEntities":
            return Optional.ofNullable(clazz.cast(revokedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("revokedEntities", REVOKED_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRevocationStatusResponse, T> g) {
        return obj -> g.apply((GetRevocationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRevocationStatusResponse> {
        /**
         * <p>
         * A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and
         * certificate hashes) supplied as input to the API.
         * </p>
         * 
         * @param revokedEntities
         *        A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and
         *        certificate hashes) supplied as input to the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedEntities(Collection<String> revokedEntities);

        /**
         * <p>
         * A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and
         * certificate hashes) supplied as input to the API.
         * </p>
         * 
         * @param revokedEntities
         *        A list of revoked entities (including zero or more of the signing profile ARN, signing job ARN, and
         *        certificate hashes) supplied as input to the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedEntities(String... revokedEntities);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private List<String> revokedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevocationStatusResponse model) {
            super(model);
            revokedEntities(model.revokedEntities);
        }

        public final Collection<String> getRevokedEntities() {
            if (revokedEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return revokedEntities;
        }

        public final void setRevokedEntities(Collection<String> revokedEntities) {
            this.revokedEntities = RevokedEntitiesCopier.copy(revokedEntities);
        }

        @Override
        public final Builder revokedEntities(Collection<String> revokedEntities) {
            this.revokedEntities = RevokedEntitiesCopier.copy(revokedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokedEntities(String... revokedEntities) {
            revokedEntities(Arrays.asList(revokedEntities));
            return this;
        }

        @Override
        public GetRevocationStatusResponse build() {
            return new GetRevocationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
