/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerClient;
import software.amazon.awssdk.services.signer.model.ListSigningJobsRequest;
import software.amazon.awssdk.services.signer.model.ListSigningJobsResponse;

public class ListSigningJobsIterable
implements SdkIterable<ListSigningJobsResponse> {
    private final SignerClient client;
    private final ListSigningJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSigningJobsIterable(SignerClient client, ListSigningJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSigningJobsResponseFetcher();
    }

    public Iterator<ListSigningJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListSigningJobsIterable resume(ListSigningJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSigningJobsIterable(this.client, (ListSigningJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSigningJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSigningJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSigningJobsResponseFetcher
    implements SyncPageFetcher<ListSigningJobsResponse> {
        private ListSigningJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSigningJobsResponse nextPage(ListSigningJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSigningJobsIterable.this.client.listSigningJobs(ListSigningJobsIterable.this.firstRequest);
            }
            return ListSigningJobsIterable.this.client.listSigningJobs((ListSigningJobsRequest)((Object)ListSigningJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

