/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerClient;
import software.amazon.awssdk.services.signer.model.ListSigningPlatformsRequest;
import software.amazon.awssdk.services.signer.model.ListSigningPlatformsResponse;

public class ListSigningPlatformsIterable
implements SdkIterable<ListSigningPlatformsResponse> {
    private final SignerClient client;
    private final ListSigningPlatformsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSigningPlatformsIterable(SignerClient client, ListSigningPlatformsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSigningPlatformsResponseFetcher();
    }

    public Iterator<ListSigningPlatformsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListSigningPlatformsIterable resume(ListSigningPlatformsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSigningPlatformsIterable(this.client, (ListSigningPlatformsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSigningPlatformsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSigningPlatformsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSigningPlatformsResponseFetcher
    implements SyncPageFetcher<ListSigningPlatformsResponse> {
        private ListSigningPlatformsResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningPlatformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSigningPlatformsResponse nextPage(ListSigningPlatformsResponse previousPage) {
            if (previousPage == null) {
                return ListSigningPlatformsIterable.this.client.listSigningPlatforms(ListSigningPlatformsIterable.this.firstRequest);
            }
            return ListSigningPlatformsIterable.this.client.listSigningPlatforms((ListSigningPlatformsRequest)((Object)ListSigningPlatformsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

