/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.Category;
import software.amazon.awssdk.services.signer.model.SigningConfiguration;
import software.amazon.awssdk.services.signer.model.SigningImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningPlatform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningPlatform> {
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(SigningPlatform.getter(SigningPlatform::platformId)).setter(SigningPlatform.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(SigningPlatform.getter(SigningPlatform::displayName)).setter(SigningPlatform.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> PARTNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partner").getter(SigningPlatform.getter(SigningPlatform::partner)).setter(SigningPlatform.setter(Builder::partner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partner").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(SigningPlatform.getter(SigningPlatform::target)).setter(SigningPlatform.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(SigningPlatform.getter(SigningPlatform::categoryAsString)).setter(SigningPlatform.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<SigningConfiguration> SIGNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingConfiguration").getter(SigningPlatform.getter(SigningPlatform::signingConfiguration)).setter(SigningPlatform.setter(Builder::signingConfiguration)).constructor(SigningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build()}).build();
    private static final SdkField<SigningImageFormat> SIGNING_IMAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingImageFormat").getter(SigningPlatform.getter(SigningPlatform::signingImageFormat)).setter(SigningPlatform.setter(Builder::signingImageFormat)).constructor(SigningImageFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingImageFormat").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSizeInMB").getter(SigningPlatform.getter(SigningPlatform::maxSizeInMB)).setter(SigningPlatform.setter(Builder::maxSizeInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSizeInMB").build()}).build();
    private static final SdkField<Boolean> REVOCATION_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("revocationSupported").getter(SigningPlatform.getter(SigningPlatform::revocationSupported)).setter(SigningPlatform.setter(Builder::revocationSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationSupported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ID_FIELD, DISPLAY_NAME_FIELD, PARTNER_FIELD, TARGET_FIELD, CATEGORY_FIELD, SIGNING_CONFIGURATION_FIELD, SIGNING_IMAGE_FORMAT_FIELD, MAX_SIZE_IN_MB_FIELD, REVOCATION_SUPPORTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("platformId", PLATFORM_ID_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("partner", PARTNER_FIELD);
            this.put("target", TARGET_FIELD);
            this.put("category", CATEGORY_FIELD);
            this.put("signingConfiguration", SIGNING_CONFIGURATION_FIELD);
            this.put("signingImageFormat", SIGNING_IMAGE_FORMAT_FIELD);
            this.put("maxSizeInMB", MAX_SIZE_IN_MB_FIELD);
            this.put("revocationSupported", REVOCATION_SUPPORTED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String platformId;
    private final String displayName;
    private final String partner;
    private final String target;
    private final String category;
    private final SigningConfiguration signingConfiguration;
    private final SigningImageFormat signingImageFormat;
    private final Integer maxSizeInMB;
    private final Boolean revocationSupported;

    private SigningPlatform(BuilderImpl builder) {
        this.platformId = builder.platformId;
        this.displayName = builder.displayName;
        this.partner = builder.partner;
        this.target = builder.target;
        this.category = builder.category;
        this.signingConfiguration = builder.signingConfiguration;
        this.signingImageFormat = builder.signingImageFormat;
        this.maxSizeInMB = builder.maxSizeInMB;
        this.revocationSupported = builder.revocationSupported;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String partner() {
        return this.partner;
    }

    public final String target() {
        return this.target;
    }

    public final Category category() {
        return Category.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final SigningConfiguration signingConfiguration() {
        return this.signingConfiguration;
    }

    public final SigningImageFormat signingImageFormat() {
        return this.signingImageFormat;
    }

    public final Integer maxSizeInMB() {
        return this.maxSizeInMB;
    }

    public final Boolean revocationSupported() {
        return this.revocationSupported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partner());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingImageFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationSupported());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningPlatform)) {
            return false;
        }
        SigningPlatform other = (SigningPlatform)obj;
        return Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.partner(), other.partner()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.signingConfiguration(), other.signingConfiguration()) && Objects.equals(this.signingImageFormat(), other.signingImageFormat()) && Objects.equals(this.maxSizeInMB(), other.maxSizeInMB()) && Objects.equals(this.revocationSupported(), other.revocationSupported());
    }

    public final String toString() {
        return ToString.builder((String)"SigningPlatform").add("PlatformId", (Object)this.platformId()).add("DisplayName", (Object)this.displayName()).add("Partner", (Object)this.partner()).add("Target", (Object)this.target()).add("Category", (Object)this.categoryAsString()).add("SigningConfiguration", (Object)this.signingConfiguration()).add("SigningImageFormat", (Object)this.signingImageFormat()).add("MaxSizeInMB", (Object)this.maxSizeInMB()).add("RevocationSupported", (Object)this.revocationSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "partner": {
                return Optional.ofNullable(clazz.cast(this.partner()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "signingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.signingConfiguration()));
            }
            case "signingImageFormat": {
                return Optional.ofNullable(clazz.cast(this.signingImageFormat()));
            }
            case "maxSizeInMB": {
                return Optional.ofNullable(clazz.cast(this.maxSizeInMB()));
            }
            case "revocationSupported": {
                return Optional.ofNullable(clazz.cast(this.revocationSupported()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SigningPlatform, T> g) {
        return obj -> g.apply((SigningPlatform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformId;
        private String displayName;
        private String partner;
        private String target;
        private String category;
        private SigningConfiguration signingConfiguration;
        private SigningImageFormat signingImageFormat;
        private Integer maxSizeInMB;
        private Boolean revocationSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningPlatform model) {
            this.platformId(model.platformId);
            this.displayName(model.displayName);
            this.partner(model.partner);
            this.target(model.target);
            this.category(model.category);
            this.signingConfiguration(model.signingConfiguration);
            this.signingImageFormat(model.signingImageFormat);
            this.maxSizeInMB(model.maxSizeInMB);
            this.revocationSupported(model.revocationSupported);
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPartner() {
            return this.partner;
        }

        public final void setPartner(String partner) {
            this.partner = partner;
        }

        @Override
        public final Builder partner(String partner) {
            this.partner = partner;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final SigningConfiguration.Builder getSigningConfiguration() {
            return this.signingConfiguration != null ? this.signingConfiguration.toBuilder() : null;
        }

        public final void setSigningConfiguration(SigningConfiguration.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        @Override
        public final Builder signingConfiguration(SigningConfiguration signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        public final SigningImageFormat.Builder getSigningImageFormat() {
            return this.signingImageFormat != null ? this.signingImageFormat.toBuilder() : null;
        }

        public final void setSigningImageFormat(SigningImageFormat.BuilderImpl signingImageFormat) {
            this.signingImageFormat = signingImageFormat != null ? signingImageFormat.build() : null;
        }

        @Override
        public final Builder signingImageFormat(SigningImageFormat signingImageFormat) {
            this.signingImageFormat = signingImageFormat;
            return this;
        }

        public final Integer getMaxSizeInMB() {
            return this.maxSizeInMB;
        }

        public final void setMaxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
        }

        @Override
        public final Builder maxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
            return this;
        }

        public final Boolean getRevocationSupported() {
            return this.revocationSupported;
        }

        public final void setRevocationSupported(Boolean revocationSupported) {
            this.revocationSupported = revocationSupported;
        }

        @Override
        public final Builder revocationSupported(Boolean revocationSupported) {
            this.revocationSupported = revocationSupported;
            return this;
        }

        public SigningPlatform build() {
            return new SigningPlatform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningPlatform> {
        public Builder platformId(String var1);

        public Builder displayName(String var1);

        public Builder partner(String var1);

        public Builder target(String var1);

        public Builder category(String var1);

        public Builder category(Category var1);

        public Builder signingConfiguration(SigningConfiguration var1);

        default public Builder signingConfiguration(Consumer<SigningConfiguration.Builder> signingConfiguration) {
            return this.signingConfiguration((SigningConfiguration)((SigningConfiguration.Builder)SigningConfiguration.builder().applyMutation(signingConfiguration)).build());
        }

        public Builder signingImageFormat(SigningImageFormat var1);

        default public Builder signingImageFormat(Consumer<SigningImageFormat.Builder> signingImageFormat) {
            return this.signingImageFormat((SigningImageFormat)((SigningImageFormat.Builder)SigningImageFormat.builder().applyMutation(signingImageFormat)).build());
        }

        public Builder maxSizeInMB(Integer var1);

        public Builder revocationSupported(Boolean var1);
    }
}

