/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.signer.DefaultSignerBaseClientBuilder;
import software.amazon.awssdk.services.signer.DefaultSignerClient;
import software.amazon.awssdk.services.signer.SignerClient;
import software.amazon.awssdk.services.signer.SignerClientBuilder;
import software.amazon.awssdk.services.signer.SignerServiceClientConfiguration;
import software.amazon.awssdk.services.signer.endpoints.SignerEndpointProvider;

@SdkInternalApi
final class DefaultSignerClientBuilder
extends DefaultSignerBaseClientBuilder<SignerClientBuilder, SignerClient>
implements SignerClientBuilder {
    DefaultSignerClientBuilder() {
    }

    @Override
    public DefaultSignerClientBuilder endpointProvider(SignerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SignerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSignerClientBuilder.validateClientOptions(clientConfiguration);
        SignerServiceClientConfiguration serviceClientConfiguration = SignerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultSignerClient(serviceClientConfiguration, clientConfiguration);
    }
}

