/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HashAlgorithm {
    SHA1("SHA1"),
    SHA256("SHA256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HashAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HashAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HashAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HashAlgorithm> knownValues() {
        return Stream.of(HashAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

