/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.HashAlgorithm;
import software.amazon.awssdk.services.signer.model.HashAlgorithmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HashAlgorithmOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HashAlgorithmOptions> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(HashAlgorithmOptions.getter(HashAlgorithmOptions::allowedValuesAsStrings)).setter(HashAlgorithmOptions.setter(Builder::allowedValuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(HashAlgorithmOptions.getter(HashAlgorithmOptions::defaultValueAsString)).setter(HashAlgorithmOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD, DEFAULT_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedValues;
    private final String defaultValue;

    private HashAlgorithmOptions(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.defaultValue = builder.defaultValue;
    }

    public final List<HashAlgorithm> allowedValues() {
        return HashAlgorithmsCopier.copyStringToEnum(this.allowedValues);
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValuesAsStrings() {
        return this.allowedValues;
    }

    public final HashAlgorithm defaultValue() {
        return HashAlgorithm.fromValue(this.defaultValue);
    }

    public final String defaultValueAsString() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValuesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValueAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashAlgorithmOptions)) {
            return false;
        }
        HashAlgorithmOptions other = (HashAlgorithmOptions)obj;
        return this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValuesAsStrings(), other.allowedValuesAsStrings()) && Objects.equals(this.defaultValueAsString(), other.defaultValueAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HashAlgorithmOptions").add("AllowedValues", this.hasAllowedValues() ? this.allowedValuesAsStrings() : null).add("DefaultValue", (Object)this.defaultValueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValuesAsStrings()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValueAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HashAlgorithmOptions, T> g) {
        return obj -> g.apply((HashAlgorithmOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HashAlgorithmOptions model) {
            this.allowedValuesWithStrings(model.allowedValues);
            this.defaultValue(model.defaultValue);
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValuesWithStrings(Collection<String> allowedValues) {
            this.allowedValues = HashAlgorithmsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValuesWithStrings(String ... allowedValues) {
            this.allowedValuesWithStrings(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        public final Builder allowedValues(Collection<HashAlgorithm> allowedValues) {
            this.allowedValues = HashAlgorithmsCopier.copyEnumToString(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(HashAlgorithm ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = HashAlgorithmsCopier.copy(allowedValues);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public final Builder defaultValue(HashAlgorithm defaultValue) {
            this.defaultValue(defaultValue == null ? null : defaultValue.toString());
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public HashAlgorithmOptions build() {
            return new HashAlgorithmOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HashAlgorithmOptions> {
        public Builder allowedValuesWithStrings(Collection<String> var1);

        public Builder allowedValuesWithStrings(String ... var1);

        public Builder allowedValues(Collection<HashAlgorithm> var1);

        public Builder allowedValues(HashAlgorithm ... var1);

        public Builder defaultValue(String var1);

        public Builder defaultValue(HashAlgorithm var1);
    }
}

