/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeSigningProfileRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, RevokeSigningProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(RevokeSigningProfileRequest.getter(RevokeSigningProfileRequest::profileName)).setter(RevokeSigningProfileRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(RevokeSigningProfileRequest.getter(RevokeSigningProfileRequest::profileVersion)).setter(RevokeSigningProfileRequest.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(RevokeSigningProfileRequest.getter(RevokeSigningProfileRequest::reason)).setter(RevokeSigningProfileRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveTime").getter(RevokeSigningProfileRequest.getter(RevokeSigningProfileRequest::effectiveTime)).setter(RevokeSigningProfileRequest.setter(Builder::effectiveTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, REASON_FIELD, EFFECTIVE_TIME_FIELD));
    private final String profileName;
    private final String profileVersion;
    private final String reason;
    private final Instant effectiveTime;

    private RevokeSigningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.reason = builder.reason;
        this.effectiveTime = builder.effectiveTime;
    }

    public String profileName() {
        return this.profileName;
    }

    public String profileVersion() {
        return this.profileVersion;
    }

    public String reason() {
        return this.reason;
    }

    public Instant effectiveTime() {
        return this.effectiveTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSigningProfileRequest)) {
            return false;
        }
        RevokeSigningProfileRequest other = (RevokeSigningProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.effectiveTime(), other.effectiveTime());
    }

    public String toString() {
        return ToString.builder((String)"RevokeSigningProfileRequest").add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("Reason", (Object)this.reason()).add("EffectiveTime", (Object)this.effectiveTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "effectiveTime": {
                return Optional.ofNullable(clazz.cast(this.effectiveTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSigningProfileRequest, T> g) {
        return obj -> g.apply((RevokeSigningProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileVersion;
        private String reason;
        private Instant effectiveTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSigningProfileRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.reason(model.reason);
            this.effectiveTime(model.effectiveTime);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getEffectiveTime() {
            return this.effectiveTime;
        }

        @Override
        public final Builder effectiveTime(Instant effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }

        public final void setEffectiveTime(Instant effectiveTime) {
            this.effectiveTime = effectiveTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSigningProfileRequest build() {
            return new RevokeSigningProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeSigningProfileRequest> {
        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder reason(String var1);

        public Builder effectiveTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

