/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.EncryptionAlgorithm;
import software.amazon.awssdk.services.signer.model.HashAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningConfigurationOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningConfigurationOverrides> {
    private static final SdkField<String> ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningConfigurationOverrides.getter(SigningConfigurationOverrides::encryptionAlgorithmAsString)).setter(SigningConfigurationOverrides.setter(Builder::encryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionAlgorithm").build()}).build();
    private static final SdkField<String> HASH_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningConfigurationOverrides.getter(SigningConfigurationOverrides::hashAlgorithmAsString)).setter(SigningConfigurationOverrides.setter(Builder::hashAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_ALGORITHM_FIELD, HASH_ALGORITHM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionAlgorithm;
    private final String hashAlgorithm;

    private SigningConfigurationOverrides(BuilderImpl builder) {
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.hashAlgorithm = builder.hashAlgorithm;
    }

    public EncryptionAlgorithm encryptionAlgorithm() {
        return EncryptionAlgorithm.fromValue(this.encryptionAlgorithm);
    }

    public String encryptionAlgorithmAsString() {
        return this.encryptionAlgorithm;
    }

    public HashAlgorithm hashAlgorithm() {
        return HashAlgorithm.fromValue(this.hashAlgorithm);
    }

    public String hashAlgorithmAsString() {
        return this.hashAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashAlgorithmAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfigurationOverrides)) {
            return false;
        }
        SigningConfigurationOverrides other = (SigningConfigurationOverrides)obj;
        return Objects.equals(this.encryptionAlgorithmAsString(), other.encryptionAlgorithmAsString()) && Objects.equals(this.hashAlgorithmAsString(), other.hashAlgorithmAsString());
    }

    public String toString() {
        return ToString.builder((String)"SigningConfigurationOverrides").add("EncryptionAlgorithm", (Object)this.encryptionAlgorithmAsString()).add("HashAlgorithm", (Object)this.hashAlgorithmAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmAsString()));
            }
            case "hashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.hashAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningConfigurationOverrides, T> g) {
        return obj -> g.apply((SigningConfigurationOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionAlgorithm;
        private String hashAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningConfigurationOverrides model) {
            this.encryptionAlgorithm(model.encryptionAlgorithm);
            this.hashAlgorithm(model.hashAlgorithm);
        }

        public final String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        @Override
        public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm(encryptionAlgorithm == null ? null : encryptionAlgorithm.toString());
            return this;
        }

        public final void setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @Override
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        @Override
        public final Builder hashAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm(hashAlgorithm == null ? null : hashAlgorithm.toString());
            return this;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        public SigningConfigurationOverrides build() {
            return new SigningConfigurationOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningConfigurationOverrides> {
        public Builder encryptionAlgorithm(String var1);

        public Builder encryptionAlgorithm(EncryptionAlgorithm var1);

        public Builder hashAlgorithm(String var1);

        public Builder hashAlgorithm(HashAlgorithm var1);
    }
}

