/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectionsResponse extends ShieldResponse implements
        ToCopyableBuilder<ListProtectionsResponse.Builder, ListProtectionsResponse> {
    private static final SdkField<List<Protection>> PROTECTIONS_FIELD = SdkField
            .<List<Protection>> builder(MarshallingType.LIST)
            .memberName("Protections")
            .getter(getter(ListProtectionsResponse::protections))
            .setter(setter(Builder::protections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Protection> builder(MarshallingType.SDK_POJO)
                                            .constructor(Protection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProtectionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Protection> protections;

    private final String nextToken;

    private ListProtectionsResponse(BuilderImpl builder) {
        super(builder);
        this.protections = builder.protections;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Protections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtections() {
        return protections != null && !(protections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of enabled <a>Protection</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtections} method.
     * </p>
     * 
     * @return The array of enabled <a>Protection</a> objects.
     */
    public final List<Protection> protections() {
        return protections;
    }

    /**
     * <p>
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining
     * available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the
     * next batch of objects by requesting the list again and providing the token that was returned by the prior call in
     * your request.
     * </p>
     * <p>
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the
     * <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but
     * may return fewer, even if more objects are still available.
     * </p>
     * <p>
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a
     * <code>NextToken</code> value.
     * </p>
     * 
     * @return When you request a list of objects from Shield Advanced, if the response does not include all of the
     *         remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You
     *         can retrieve the next batch of objects by requesting the list again and providing the token that was
     *         returned by the prior call in your request. </p>
     *         <p>
     *         You can indicate the maximum number of objects that you want Shield Advanced to return for a single call
     *         with the <code>MaxResults</code> setting. Shield Advanced will not return more than
     *         <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.
     *         </p>
     *         <p>
     *         Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include
     *         a <code>NextToken</code> value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProtections() ? protections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsResponse)) {
            return false;
        }
        ListProtectionsResponse other = (ListProtectionsResponse) obj;
        return hasProtections() == other.hasProtections() && Objects.equals(protections(), other.protections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectionsResponse").add("Protections", hasProtections() ? protections() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protections":
            return Optional.ofNullable(clazz.cast(protections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Protections", PROTECTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectionsResponse, T> g) {
        return obj -> g.apply((ListProtectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProtectionsResponse> {
        /**
         * <p>
         * The array of enabled <a>Protection</a> objects.
         * </p>
         * 
         * @param protections
         *        The array of enabled <a>Protection</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protections(Collection<Protection> protections);

        /**
         * <p>
         * The array of enabled <a>Protection</a> objects.
         * </p>
         * 
         * @param protections
         *        The array of enabled <a>Protection</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protections(Protection... protections);

        /**
         * <p>
         * The array of enabled <a>Protection</a> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.Protection.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.shield.model.Protection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.Protection.Builder#build()} is called immediately and its
         * result is passed to {@link #protections(List<Protection>)}.
         * 
         * @param protections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.Protection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protections(java.util.Collection<Protection>)
         */
        Builder protections(Consumer<Protection.Builder>... protections);

        /**
         * <p>
         * When you request a list of objects from Shield Advanced, if the response does not include all of the
         * remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can
         * retrieve the next batch of objects by requesting the list again and providing the token that was returned by
         * the prior call in your request.
         * </p>
         * <p>
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with
         * the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code>
         * objects, but may return fewer, even if more objects are still available.
         * </p>
         * <p>
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a
         * <code>NextToken</code> value.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects from Shield Advanced, if the response does not include all of the
         *        remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response.
         *        You can retrieve the next batch of objects by requesting the list again and providing the token that
         *        was returned by the prior call in your request. </p>
         *        <p>
         *        You can indicate the maximum number of objects that you want Shield Advanced to return for a single
         *        call with the <code>MaxResults</code> setting. Shield Advanced will not return more than
         *        <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.
         *        </p>
         *        <p>
         *        Whenever more objects remain that Shield Advanced has not yet returned to you, the response will
         *        include a <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private List<Protection> protections = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionsResponse model) {
            super(model);
            protections(model.protections);
            nextToken(model.nextToken);
        }

        public final List<Protection.Builder> getProtections() {
            List<Protection.Builder> result = ProtectionsCopier.copyToBuilder(this.protections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtections(Collection<Protection.BuilderImpl> protections) {
            this.protections = ProtectionsCopier.copyFromBuilder(protections);
        }

        @Override
        public final Builder protections(Collection<Protection> protections) {
            this.protections = ProtectionsCopier.copy(protections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Protection... protections) {
            protections(Arrays.asList(protections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Consumer<Protection.Builder>... protections) {
            protections(Stream.of(protections).map(c -> Protection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtectionsResponse build() {
            return new ListProtectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
