/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateHealthCheckRequest extends ShieldRequest implements
        ToCopyableBuilder<DisassociateHealthCheckRequest.Builder, DisassociateHealthCheckRequest> {
    private static final SdkField<String> PROTECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectionId").getter(getter(DisassociateHealthCheckRequest::protectionId))
            .setter(setter(Builder::protectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionId").build()).build();

    private static final SdkField<String> HEALTH_CHECK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckArn").getter(getter(DisassociateHealthCheckRequest::healthCheckArn))
            .setter(setter(Builder::healthCheckArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_ID_FIELD,
            HEALTH_CHECK_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectionId;

    private final String healthCheckArn;

    private DisassociateHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.protectionId = builder.protectionId;
        this.healthCheckArn = builder.healthCheckArn;
    }

    /**
     * <p>
     * The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from.
     * </p>
     * 
     * @return The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from.
     */
    public final String protectionId() {
        return protectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the health check that is associated with the protection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the health check that is associated with the protection.
     */
    public final String healthCheckArn() {
        return healthCheckArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectionId());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateHealthCheckRequest)) {
            return false;
        }
        DisassociateHealthCheckRequest other = (DisassociateHealthCheckRequest) obj;
        return Objects.equals(protectionId(), other.protectionId()) && Objects.equals(healthCheckArn(), other.healthCheckArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateHealthCheckRequest").add("ProtectionId", protectionId())
                .add("HealthCheckArn", healthCheckArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionId":
            return Optional.ofNullable(clazz.cast(protectionId()));
        case "HealthCheckArn":
            return Optional.ofNullable(clazz.cast(healthCheckArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectionId", PROTECTION_ID_FIELD);
        map.put("HealthCheckArn", HEALTH_CHECK_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateHealthCheckRequest, T> g) {
        return obj -> g.apply((DisassociateHealthCheckRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ShieldRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateHealthCheckRequest> {
        /**
         * <p>
         * The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from.
         * </p>
         * 
         * @param protectionId
         *        The unique identifier (ID) for the <a>Protection</a> object to remove the health check association
         *        from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionId(String protectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the health check that is associated with the protection.
         * </p>
         * 
         * @param healthCheckArn
         *        The Amazon Resource Name (ARN) of the health check that is associated with the protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckArn(String healthCheckArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private String protectionId;

        private String healthCheckArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateHealthCheckRequest model) {
            super(model);
            protectionId(model.protectionId);
            healthCheckArn(model.healthCheckArn);
        }

        public final String getProtectionId() {
            return protectionId;
        }

        public final void setProtectionId(String protectionId) {
            this.protectionId = protectionId;
        }

        @Override
        public final Builder protectionId(String protectionId) {
            this.protectionId = protectionId;
            return this;
        }

        public final String getHealthCheckArn() {
            return healthCheckArn;
        }

        public final void setHealthCheckArn(String healthCheckArn) {
            this.healthCheckArn = healthCheckArn;
        }

        @Override
        public final Builder healthCheckArn(String healthCheckArn) {
            this.healthCheckArn = healthCheckArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateHealthCheckRequest build() {
            return new DisassociateHealthCheckRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
